package com.liveperson.infra.model;


import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.utils.EncryptionVersion;

import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * Created by ofira on 09/07/2015.
 */
public class Message {

    private static final String TAG = Message.class.getSimpleName();
    public static final String EXTRA_MESSAGE_TEXT = "EXTRA_MESSAGE_TEXT";

    private int mServerSequence = -1;
    private String mMessage;
    private String mContentType = "text/plain";
    private long mId;
    private String mDialogId;

    private long mTimeStamp;
    private String mOriginatorId;
    private String mEventId;//Unique id sent to server with this message. we keep it in order to update the server sequence ID
    //private int mEncryptionVersion = 0;

    public Message(String originatorId, String message, long timeStamp, String dialogId, String eventId, EncryptionVersion encryptionVersion) {
        mOriginatorId = originatorId;
        mMessage = DBEncryptionHelper.decrypt(encryptionVersion, message);
        mTimeStamp = timeStamp;
        mDialogId = dialogId;
        mEventId = eventId;
    }

    @Override
    public String toString() {
        return String.format("Message %s\nDialog id %s\nTimeStamp %s\nEventId %s\nServerSequence %s\nOriginatorId %s", mMessage, mDialogId, mTimeStamp, mEventId, mServerSequence, mOriginatorId);
    }

    public long getLocalId() {
        return mId;
    }


    public void setMessageId(long messageId) {
        mId = messageId;
    }


    public String getMessage() {
        return mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public long getTimeStamp() {
        return mTimeStamp;
    }


    public String getFullTimeString() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(mTimeStamp);

        SimpleDateFormat format = new SimpleDateFormat("EEEE, MMMM d, yyyy 'at' h:mm a");
        return format.format(cal.getTime());
    }

    public String getDialogId() {
        return mDialogId;
    }

    public String getContentType() {
        return mContentType;
    }

    public int getServerSequence() {
        return mServerSequence;
    }

    public String getOriginatorId() {
        return mOriginatorId;
    }

    public void setDialogId(String dialogId) {
        this.mDialogId = dialogId;
    }

    public void setContentType(String contentType) {
        mContentType = contentType;
    }

    public void setEventId(String eventId) {
        mEventId = eventId;
    }

    public String getEventId() {
        return mEventId;
    }

    public void setServerSequence(int serverSequence) {
        mServerSequence = serverSequence;
    }
}