package com.liveperson.infra.utils;

import android.support.annotation.Nullable;

import java.util.ArrayList;
import java.util.Collection;

public class CollectionsUtil {
    public interface Predicate<T> {

        /**
         * Evaluates this predicate on the given argument.
         *
         * @param t the input argument
         * @return {@code true} if the input argument matches the predicate,
         * otherwise {@code false}
         */
        boolean test(T t);
    }

    public static <T> ArrayList<T> filter(Collection<T> list, Predicate<T> predicate) {
        ArrayList<T> filtered = new ArrayList<>();
        for (T element : list) {
            if (predicate.test(element)) {
                filtered.add(element);
            }
        }

        return filtered;
    }
}
