package com.liveperson.infra.utils;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static final String TAG = "FileUtils";

    private static String IMAGES_FOLDER = "images/";
    private static String VOICE_FOLDER = "voice/";
    private static String DOCUMENTS_FOLDER = "documents/";

    public static boolean copyFile(File privateDirectory, File publicDirectory) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(privateDirectory);
            out = new FileOutputStream(publicDirectory);
            byte[] b = new byte[1024 * 5];
            int len = 0;
            while ((len = in.read(b)) > 0) {
                out.write(b, 0, len);
            }
        } catch (Exception e) {
            LPMobileLog.e(TAG,e);
        } finally {
            try {
                if (out != null) {
                    out.close();
                }
            } catch (IOException e) {
                LPMobileLog.e(TAG,e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                LPMobileLog.e(TAG,e);
            }
        }
        return privateDirectory.getName().equals(publicDirectory.getName());
    }


    /**
     * Delete all downloaded files shared with agent
     */
    public static void deleteAllSharedFiles() {

        LPMobileLog.d(TAG,"deleting all shared files with agent");
        deleteFolder(IMAGES_FOLDER);
        deleteFolder(VOICE_FOLDER);
        deleteFolder(DOCUMENTS_FOLDER);
    }

    /**
     * Delete all files stored on the device. This should be called when the user logs out his account
     *
     * @param folderName
     */
    private static void deleteFolder(String folderName) {

        File dirToDelete = new File(Infra.instance.getApplicationContext().getFilesDir() + "/" + folderName + "/");

        LPMobileLog.d(TAG, "delete" + folderName + "Folder: Trying to delete the" + folderName + "folder:" + dirToDelete.getAbsolutePath());

        deleteRecursive(dirToDelete);
    }

    /**
     * Recursively delete all files and file folder from the device
     *
     * @param fileOrDirectory
     */
    private static void deleteRecursive(File fileOrDirectory) {

        if (fileOrDirectory.isDirectory()) {
            LPMobileLog.d(TAG, "deleteRecursive: deleting directory: " + fileOrDirectory.getAbsolutePath());

            for (File child : fileOrDirectory.listFiles()) {
                LPMobileLog.d(TAG, "deleteRecursive: deleting file: " + child.getAbsolutePath());
                deleteRecursive(child);
            }
        }

        //noinspection ResultOfMethodCallIgnored
        fileOrDirectory.delete();
    }

}
