package com.liveperson.infra.utils;

import com.liveperson.infra.log.LPMobileLog;

/**
 * Created by shiranr on 15/06/2016.
 */
public class MaskedMessage {
    String dbMessage;
    String serverMessage;
    String maskedSystemMessage;
    private boolean isMasked;

    public MaskedMessage(String dbMessage, String serverMessage, boolean masked, String maskedSystemMessage) {
        this.dbMessage = dbMessage;
        this.serverMessage = serverMessage;
        isMasked = masked;
        this.maskedSystemMessage = maskedSystemMessage;
        LPMobileLog.d("MaskedMessage", "dbMessage: "+ dbMessage + ", serverMessage: "+ serverMessage + ", isMasked: " + isMasked);
    }

    public String getDbMessage() {
        return dbMessage;
    }

    public String getServerMessage() {
        return serverMessage;
    }

    public boolean isMasked() {
        return isMasked;
    }

    public String getMaskedSystemMessage() {
        return maskedSystemMessage;
    }

    public void setDbMessage(String message) {
         dbMessage = message;
    }

    public void setServerMessage(String message) {
        serverMessage = message;
        LPMobileLog.w("MaskedMessage", "dbMessage------> "+ dbMessage);
    }
}
