/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.os.Parcel;
import android.os.Parcelable;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.LPConversationHistoryMaxDaysDateType;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.model.LPWelcomeMessage;

public class ConversationViewParams
implements Parcelable {
    boolean viewOnlyMode = false;
    CampaignInfo mCampaignInfo;
    LPConversationsHistoryStateToDisplay mHistoryConversationsStateToDisplay = LPConversationsHistoryStateToDisplay.ALL;
    LPConversationHistoryMaxDaysDateType mHistoryConversationMaxDaysType = LPConversationHistoryMaxDaysDateType.startConversationDate;
    int mHistoryConversationsMaxDays = -1;
    private LPWelcomeMessage lpWelcomeMessage;
    public static final Parcelable.Creator<ConversationViewParams> CREATOR = new Parcelable.Creator<ConversationViewParams>(){

        public ConversationViewParams createFromParcel(Parcel in) {
            return new ConversationViewParams(in);
        }

        public ConversationViewParams[] newArray(int size) {
            return new ConversationViewParams[size];
        }
    };

    public ConversationViewParams() {
        this.lpWelcomeMessage = new LPWelcomeMessage(null);
    }

    public ConversationViewParams(boolean readOnlyMode) {
        this();
        this.setReadOnlyMode(readOnlyMode);
    }

    public ConversationViewParams setReadOnlyMode(boolean readOnlyMode) {
        this.viewOnlyMode = readOnlyMode;
        if (!this.viewOnlyMode && this.mHistoryConversationsStateToDisplay == LPConversationsHistoryStateToDisplay.CLOSE) {
            this.viewOnlyMode = true;
        }
        return this;
    }

    public ConversationViewParams setCampaignInfo(CampaignInfo campaignInfo) {
        this.mCampaignInfo = campaignInfo;
        return this;
    }

    public ConversationViewParams setHistoryConversationsStateToDisplay(LPConversationsHistoryStateToDisplay historyConversationsStateToDisplay) {
        this.mHistoryConversationsStateToDisplay = historyConversationsStateToDisplay;
        if (this.mHistoryConversationsStateToDisplay == LPConversationsHistoryStateToDisplay.CLOSE) {
            this.viewOnlyMode = true;
        }
        return this;
    }

    public ConversationViewParams setHistoryConversationMaxDaysType(LPConversationHistoryMaxDaysDateType historyConversationMaxDaysType) {
        this.mHistoryConversationMaxDaysType = historyConversationMaxDaysType;
        return this;
    }

    public ConversationViewParams setHistoryConversationsMaxDays(int historyConversationsMaxDays) {
        if (historyConversationsMaxDays >= -1) {
            this.mHistoryConversationsMaxDays = historyConversationsMaxDays;
        }
        return this;
    }

    public LPConversationsHistoryStateToDisplay getHistoryConversationsStateToDisplay() {
        return this.mHistoryConversationsStateToDisplay;
    }

    public LPConversationHistoryMaxDaysDateType getHistoryConversationMaxDaysType() {
        return this.mHistoryConversationMaxDaysType;
    }

    public int getHistoryConversationsMaxDays() {
        return this.mHistoryConversationsMaxDays;
    }

    public boolean isViewOnlyMode() {
        return this.viewOnlyMode;
    }

    public CampaignInfo getCampaignInfo() {
        return this.mCampaignInfo;
    }

    public void clearCampaignInfo() {
        this.mCampaignInfo = null;
    }

    public boolean isFilterOn() {
        return this.mHistoryConversationsStateToDisplay != LPConversationsHistoryStateToDisplay.ALL || this.mHistoryConversationsMaxDays != -1;
    }

    public void setLpWelcomeMessage(LPWelcomeMessage lpWelcomeMessage) {
        this.lpWelcomeMessage = lpWelcomeMessage;
    }

    public LPWelcomeMessage getLpWelcomeMessage() {
        return this.lpWelcomeMessage;
    }

    public String toString() {
        return "State To Display = " + this.mHistoryConversationsStateToDisplay.name() + ", Max Days = " + this.mHistoryConversationsMaxDays + ", Max Days Type = " + this.mHistoryConversationMaxDaysType.name();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.viewOnlyMode ? 1 : 0));
        dest.writeParcelable((Parcelable)this.mCampaignInfo, flags);
        dest.writeInt(this.mHistoryConversationsMaxDays);
        dest.writeInt(this.mHistoryConversationMaxDaysType.ordinal());
        dest.writeInt(this.mHistoryConversationsStateToDisplay.ordinal());
        dest.writeParcelable((Parcelable)this.lpWelcomeMessage, flags);
    }

    protected ConversationViewParams(Parcel in) {
        this.viewOnlyMode = in.readByte() != 0;
        this.mCampaignInfo = (CampaignInfo)in.readParcelable(CampaignInfo.class.getClassLoader());
        this.mHistoryConversationsMaxDays = in.readInt();
        this.mHistoryConversationMaxDaysType = LPConversationHistoryMaxDaysDateType.values()[in.readInt()];
        this.mHistoryConversationsStateToDisplay = LPConversationsHistoryStateToDisplay.values()[in.readInt()];
        this.lpWelcomeMessage = (LPWelcomeMessage)in.readParcelable(ConversationViewParams.class.getClassLoader());
    }
}

