/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import android.os.Handler;
import android.os.Looper;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.log.LPMobileLog;

public class DataBaseCommand<DATA> {
    private QueryCommand<DATA> mQueryCommand;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    protected QueryCallback<DATA> mPostQueryOnUI;
    protected Runnable mPreQueryOnBackground;
    protected QueryCallback<DATA> mPostQueryOnBackground;

    public DataBaseCommand(QueryCommand<DATA> queryCommand) {
        this.mQueryCommand = queryCommand;
    }

    public static <DATA> DataBaseCommand<DATA> create(QueryCommand<DATA> queryCommand) {
        return new DataBaseCommand<DATA>(queryCommand);
    }

    public DataBaseCommand<DATA> setPostQueryOnUI(QueryCallback<DATA> callback) {
        this.mPostQueryOnUI = callback;
        return this;
    }

    public DataBaseCommand<DATA> setPreQueryOnBackground(Runnable callback) {
        this.mPreQueryOnBackground = callback;
        return this;
    }

    public DataBaseCommand<DATA> setPostQueryOnBackground(QueryCallback<DATA> callback) {
        this.mPostQueryOnBackground = callback;
        return this;
    }

    public DATA executeSynchronously() {
        return this.mQueryCommand.query();
    }

    public void execute() {
        DataBaseExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (DataBaseCommand.this.mPreQueryOnBackground != null) {
                        DataBaseCommand.this.mPreQueryOnBackground.run();
                    }
                    final Object data = DataBaseCommand.this.executeSynchronously();
                    if (DataBaseCommand.this.mPostQueryOnBackground != null) {
                        DataBaseCommand.this.mPostQueryOnBackground.onResult(data);
                    }
                    if (DataBaseCommand.this.mPostQueryOnUI != null) {
                        DataBaseCommand.this.mUIHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                DataBaseCommand.this.mPostQueryOnUI.onResult(data);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    LPMobileLog.e("DataBaseCommand", "Error while running DataBaseCommand. Exception: " + e);
                    LPMobileLog.e("DataBaseCommand", e);
                }
            }
        });
    }

    public static interface QueryCallback<T> {
        public void onResult(T var1);
    }

    public static interface QueryCommand<T> {
        public T query();
    }
}

