/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.LptagData;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONException;
import org.json.JSONObject;

public class LptagRequest
implements Command {
    private static final String TAG = LptagRequest.class.getSimpleName();
    private static final String LPTAG_URL = "https://%1$s/lptag/api/account/%2$s/configuration/applications/taglets/?v=2.0&scp=mb";
    private static final int LPTAG_REQUEST_TIMEOUT = 30000;
    public static final String JSON_KEY_FEATURES = "features";
    public static final String JSON_KEY_RETRY = "retry";
    public static final String JSON_KEY_RETRY_TIMEOUT = "timeout";
    public static final String JSON_KEY_MAX_RETRIES = "maxRetries";
    public static final String JSON_KEY_MESSAGING_AUTO_MESSAGES = "Messaging.Auto_Messages";
    private ICallback mCallback;
    private String mBrandId;
    private String mDomain;
    private List<String> mCertificates;

    public LptagRequest(String domain, String brandId, List<String> certificates, ICallback callback) {
        this.mCallback = callback;
        this.mBrandId = brandId;
        this.mDomain = domain;
        this.mCertificates = certificates;
    }

    @Override
    public void execute() {
        String lptagRequestUrl = String.format(LPTAG_URL, this.mDomain, this.mBrandId);
        HttpGetRequest httpGetRequest = new HttpGetRequest(lptagRequestUrl);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String lptagString) {
                block6: {
                    LPMobileLog.d(TAG, "onSuccess: received response: " + lptagString);
                    LptagData lptagData = new LptagData();
                    if (!TextUtils.isEmpty((CharSequence)lptagString)) {
                        try {
                            JSONObject lptagJson = new JSONObject(lptagString);
                            JSONObject featuresJsonObject = lptagJson.optJSONObject(LptagRequest.JSON_KEY_FEATURES);
                            if (featuresJsonObject == null) {
                                JSONObject retry = lptagJson.optJSONObject(LptagRequest.JSON_KEY_RETRY);
                                if (retry != null) {
                                    LPMobileLog.d(TAG, "onSuccess: Received Retry json. Parse and return");
                                    LptagRequest.this.extractRetryFromJson(lptagData, retry);
                                }
                                LptagRequest.this.mCallback.onSuccess(lptagData);
                                break block6;
                            }
                            LPMobileLog.d(TAG, "onSuccess: Received Features json. Parse and return");
                            LptagRequest.this.extractFeaturesFromJson(lptagData, featuresJsonObject);
                            LptagRequest.this.mCallback.onSuccess(lptagData);
                        }
                        catch (JSONException je) {
                            LPMobileLog.w(TAG, "Error parsing LPTag data. AutoMessage is Off. Return success");
                            LptagRequest.this.mCallback.onSuccess(lptagData);
                        }
                    } else {
                        LPMobileLog.w(TAG, "LPTag failed! lptagString is empty. AutoMessage is Off. Return success");
                        LptagRequest.this.mCallback.onSuccess(lptagData);
                    }
                }
            }

            @Override
            public void onError(Exception exception) {
                LPMobileLog.w(TAG, "LPTag failed! Received error. AutoMessage is Off. Return success");
                if (exception instanceof SSLPeerUnverifiedException) {
                    LptagRequest.this.mCallback.onError(exception);
                    return;
                }
                LptagRequest.this.mCallback.onSuccess(new LptagData());
            }
        });
        HttpHandler.execute(httpGetRequest);
    }

    private void extractRetryFromJson(LptagData lptagData, JSONObject retry) {
        lptagData.setRetryTimeout(retry.optInt(JSON_KEY_RETRY_TIMEOUT, 0));
        lptagData.setMaxRetries(retry.optInt(JSON_KEY_MAX_RETRIES, 0));
        lptagData.setAutoMessagesFeatureEnabled(false);
    }

    private void extractFeaturesFromJson(LptagData lptagData, JSONObject featuresJsonObject) throws JSONException {
        lptagData.setAutoMessagesFeatureEnabled(featuresJsonObject.optBoolean(JSON_KEY_MESSAGING_AUTO_MESSAGES));
        lptagData.setRetryTimeout(0);
        lptagData.setMaxRetries(0);
    }
}

