/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.liveperson.infra.utils.picasso.Cache;
import com.liveperson.infra.utils.picasso.Utils;

public final class LruCache
implements Cache {
    final android.util.LruCache<String, BitmapAndSize> cache;

    public LruCache(@NonNull Context context) {
        this(Utils.calculateMemoryCacheSize(context));
    }

    public LruCache(int maxByteCount) {
        this.cache = new android.util.LruCache<String, BitmapAndSize>(maxByteCount){

            protected int sizeOf(String key, BitmapAndSize value) {
                return value.byteCount;
            }
        };
    }

    @Override
    @Nullable
    public Bitmap get(@NonNull String key) {
        BitmapAndSize bitmapAndSize = (BitmapAndSize)this.cache.get((Object)key);
        return bitmapAndSize != null ? bitmapAndSize.bitmap : null;
    }

    @Override
    public void set(@NonNull String key, @NonNull Bitmap bitmap) {
        if (key == null || bitmap == null) {
            throw new NullPointerException("key == null || bitmap == null");
        }
        int byteCount = Utils.getBitmapBytes(bitmap);
        if (byteCount > this.maxSize()) {
            this.cache.remove((Object)key);
            return;
        }
        this.cache.put((Object)key, (Object)new BitmapAndSize(bitmap, byteCount));
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public int maxSize() {
        return this.cache.maxSize();
    }

    @Override
    public void clear() {
        this.cache.evictAll();
    }

    @Override
    public void clearKeyUri(String uri) {
        for (String key : this.cache.snapshot().keySet()) {
            if (!key.startsWith(uri) || key.length() <= uri.length() || key.charAt(uri.length()) != '\n') continue;
            this.cache.remove((Object)key);
        }
    }

    public int hitCount() {
        return this.cache.hitCount();
    }

    public int missCount() {
        return this.cache.missCount();
    }

    public int putCount() {
        return this.cache.putCount();
    }

    public int evictionCount() {
        return this.cache.evictionCount();
    }

    static final class BitmapAndSize {
        final Bitmap bitmap;
        final int byteCount;

        BitmapAndSize(Bitmap bitmap, int byteCount) {
            this.bitmap = bitmap;
            this.byteCount = byteCount;
        }
    }
}

