package com.liveperson.infra.log.logreporter.loggos;

import com.liveperson.infra.log.LPMobileLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;

/**
 * Created by nirni on 3/16/16.
 */
public class LoggosMessage {

	public static final String TAG = LoggosMessage.class.getSimpleName();

	protected static final String LOG_LEVEL = "logLevel";
	protected static final String CONTEXT = "context";
	protected static final String MESSAGE = "msg";
	protected static final String NAMESPACE = "namespace";
	protected static final String ACCOUNT_ID = "accountId";
	protected static final String URL = "url";
	protected static final String TIME = "time";
	protected static final String SDK_VERSION = "integrationVersion";

	protected static final String DATE_FORMAT = "yyyy-mm-dd HH:MM:SS,SSS";

	private String mLevel;
	private String mLogContext;
	private String mMessage;
	private String mNamespace;
	private String mAccountId;
	private String mUrl;
	private String mTime;
	private String mSdkVersion;

	private boolean isFeatureStatistics;

	private SimpleDateFormat mDateFormat;

	public LoggosMessage(String level, String logContext, String message, String namespace) {
		mLevel = level;
		mLogContext = logContext;
		mMessage = message;
		mNamespace = namespace;
	}

	public LoggosMessage(String level, String logContext, String message, String namespace, String accountId) {

		this(level, logContext, message, namespace);
		mAccountId = accountId;

		mDateFormat = new SimpleDateFormat(DATE_FORMAT);
	}

	public LoggosMessage(JSONObject jsonObject) {

		try {
			mLevel = jsonObject.getString(LOG_LEVEL);
			mLogContext = jsonObject.getString(CONTEXT);
			mMessage = jsonObject.getString(MESSAGE);
			mNamespace = jsonObject.getString(NAMESPACE);
			mAccountId = jsonObject.getString(ACCOUNT_ID);
			mUrl = jsonObject.getString(URL);
			mTime = jsonObject.getString(TIME);

		} catch (JSONException e) {
			LPMobileLog.d(TAG, "toJsonObject: JSONException " + e.getMessage());
		}
	}

	public JSONObject toJsonObject() {

		JSONObject jsonObject = new JSONObject();
		try {
			jsonObject.put(LOG_LEVEL, mLevel);
			jsonObject.put(CONTEXT, mLogContext);
			jsonObject.put(MESSAGE, mMessage);
			jsonObject.put(NAMESPACE, mNamespace);
			jsonObject.put(ACCOUNT_ID, mAccountId);
			jsonObject.put(URL, mUrl);
			jsonObject.put(TIME, mTime);

			if (isFeatureStatistics) {
				jsonObject.put(SDK_VERSION, mSdkVersion);
			}

		} catch (JSONException e) {
			LPMobileLog.d(TAG, "toJsonObject: JSONException " + e.getMessage());
		}

		return jsonObject;
	}



	/////////////////// Setters + Getters /////////////////////////////////

	public String getLevel() {
		return mLevel;
	}

	public LoggosMessage setLevel(String level) {
		mLevel = level;
		return this;
	}

	public String getLogContext() {
		return mLogContext;
	}

	public LoggosMessage setLogContext(String logContext) {
		mLogContext = logContext;
		return this;
	}

	public String getMessage() {
		return mMessage;
	}

	public LoggosMessage setMessage(String message) {
		mMessage = message;
		return this;
	}

	public String getNamespace() {
		return mNamespace;
	}

	public LoggosMessage setNamespace(String namespace) {
		mNamespace = namespace;
		return this;
	}

	public String getAccountId() {
		return mAccountId;
	}

	public LoggosMessage setAccountId(String accountId) {
		mAccountId = accountId;
		return this;
	}

	public String getUrl() {
		return mUrl;
	}

	public LoggosMessage setUrl(String url) {
		mUrl = url;
		return this;
	}

	public String getTime() {
		return mTime;
	}

	public LoggosMessage setTime(String time) {
		mTime = time;
		return this;
	}

	public LoggosMessage setTime(long timestamp) {
		mTime = mDateFormat.format(timestamp);
		return this;
	}

	public void setIsFeatureStatistics(boolean value) {
		isFeatureStatistics = value;
	}

	public boolean getIsFeatureStatistics() {
		return isFeatureStatistics;
	}

	public void setSdkVersion(String sdkVersion) {
		mSdkVersion = sdkVersion;
	}
}
