/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log.logreporter.loggos;

import com.liveperson.infra.log.LPMobileLog;
import java.text.SimpleDateFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class LoggosMessage {
    public static final String TAG = LoggosMessage.class.getSimpleName();
    protected static final String LOG_LEVEL = "logLevel";
    protected static final String CONTEXT = "context";
    protected static final String MESSAGE = "msg";
    protected static final String NAMESPACE = "namespace";
    protected static final String ACCOUNT_ID = "accountId";
    protected static final String URL = "url";
    protected static final String TIME = "time";
    protected static final String SDK_VERSION = "integrationVersion";
    protected static final String DATE_FORMAT = "yyyy-mm-dd HH:MM:SS,SSS";
    private String mLevel;
    private String mLogContext;
    private String mMessage;
    private String mNamespace;
    private String mAccountId;
    private String mUrl;
    private String mTime;
    private String mSdkVersion;
    private boolean isFeatureStatistics;
    private SimpleDateFormat mDateFormat;

    public LoggosMessage(String level, String logContext, String message, String namespace) {
        this.mLevel = level;
        this.mLogContext = logContext;
        this.mMessage = message;
        this.mNamespace = namespace;
    }

    public LoggosMessage(String level, String logContext, String message, String namespace, String accountId) {
        this(level, logContext, message, namespace);
        this.mAccountId = accountId;
        this.mDateFormat = new SimpleDateFormat(DATE_FORMAT);
    }

    public LoggosMessage(JSONObject jsonObject) {
        try {
            this.mLevel = jsonObject.getString(LOG_LEVEL);
            this.mLogContext = jsonObject.getString(CONTEXT);
            this.mMessage = jsonObject.getString(MESSAGE);
            this.mNamespace = jsonObject.getString(NAMESPACE);
            this.mAccountId = jsonObject.getString(ACCOUNT_ID);
            this.mUrl = jsonObject.getString(URL);
            this.mTime = jsonObject.getString(TIME);
        }
        catch (JSONException e) {
            LPMobileLog.d(TAG, "toJsonObject: JSONException " + e.getMessage());
        }
    }

    public JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(LOG_LEVEL, (Object)this.mLevel);
            jsonObject.put(CONTEXT, (Object)this.mLogContext);
            jsonObject.put(MESSAGE, (Object)this.mMessage);
            jsonObject.put(NAMESPACE, (Object)this.mNamespace);
            jsonObject.put(ACCOUNT_ID, (Object)this.mAccountId);
            jsonObject.put(URL, (Object)this.mUrl);
            jsonObject.put(TIME, (Object)this.mTime);
            if (this.isFeatureStatistics) {
                jsonObject.put(SDK_VERSION, (Object)this.mSdkVersion);
            }
        }
        catch (JSONException e) {
            LPMobileLog.d(TAG, "toJsonObject: JSONException " + e.getMessage());
        }
        return jsonObject;
    }

    public String getLevel() {
        return this.mLevel;
    }

    public LoggosMessage setLevel(String level) {
        this.mLevel = level;
        return this;
    }

    public String getLogContext() {
        return this.mLogContext;
    }

    public LoggosMessage setLogContext(String logContext) {
        this.mLogContext = logContext;
        return this;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public LoggosMessage setMessage(String message) {
        this.mMessage = message;
        return this;
    }

    public String getNamespace() {
        return this.mNamespace;
    }

    public LoggosMessage setNamespace(String namespace) {
        this.mNamespace = namespace;
        return this;
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public LoggosMessage setAccountId(String accountId) {
        this.mAccountId = accountId;
        return this;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public LoggosMessage setUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public String getTime() {
        return this.mTime;
    }

    public LoggosMessage setTime(String time) {
        this.mTime = time;
        return this;
    }

    public LoggosMessage setTime(long timestamp) {
        this.mTime = this.mDateFormat.format(timestamp);
        return this;
    }

    public void setIsFeatureStatistics(boolean value) {
        this.isFeatureStatistics = value;
    }

    public boolean getIsFeatureStatistics() {
        return this.isFeatureStatistics;
    }

    public void setSdkVersion(String sdkVersion) {
        this.mSdkVersion = sdkVersion;
    }
}

