/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.utils.UniqueID;
import java.util.ArrayList;

public abstract class BaseSocketRequest<T, REQUEST extends BaseSocketRequest> {
    private ArrayList<ResponseCallback<T>> mCallbacks = new ArrayList();
    private long mRequestId;

    public static long createRequestId() {
        return UniqueID.getUniqueID();
    }

    public BaseSocketRequest() {
        this.mRequestId = BaseSocketRequest.createRequestId();
    }

    public BaseSocketRequest(long requestId) {
        this.mRequestId = requestId;
    }

    protected abstract String getSocketUrl();

    protected abstract String getData();

    protected abstract String getRequestName();

    protected abstract BaseResponseHandler<T, REQUEST> getResponseHandler();

    public long getRequestId() {
        return this.mRequestId;
    }

    public BaseSocketRequest setRequestId(long requestId) {
        this.mRequestId = requestId;
        return this;
    }

    public REQUEST addCallback(ResponseCallback<T> callback) {
        this.mCallbacks.add(callback);
        return (REQUEST)this;
    }

    public REQUEST removeCallback(ResponseCallback<T> callback) {
        this.mCallbacks.remove(callback);
        return (REQUEST)this;
    }

    void dispatchError() {
        for (ResponseCallback<T> callback : this.mCallbacks) {
            callback.onError();
        }
    }

    void dispatchSuccess(T data) {
        for (ResponseCallback<T> callback : this.mCallbacks) {
            callback.onSuccess(data);
        }
    }
}

