/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public class ResponseMap
implements ShutDown {
    private static final String TAG = ResponseMap.class.getSimpleName();
    public static final String RESPONSE_TAG = "FLOW_RESPONSES_";
    private ConcurrentHashMap<String, Class<? extends BaseResponseHandler>> mGeneralMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, BaseResponseHandler> uIDMap = new ConcurrentHashMap();
    private GeneralResponseHandler generalResponseHandler = null;

    public void putRequestIdHandler(long requestId, BaseResponseHandler handler) {
        if (this.uIDMap.containsKey(requestId)) {
            this.uIDMap.remove(requestId);
        }
        this.uIDMap.put(requestId, handler);
    }

    public void putGeneralHandler(String messageType, Class<? extends BaseResponseHandler> handler) {
        if (this.mGeneralMap.containsKey(messageType)) {
            this.mGeneralMap.remove(messageType);
        }
        this.mGeneralMap.put(messageType, handler);
    }

    public void onRequestHandled(long requestId) {
        if (this.uIDMap.containsKey(requestId)) {
            this.uIDMap.remove(requestId);
            LPMobileLog.d(TAG, "onRequestHandled: " + requestId + ", removing it from map. map = " + Arrays.toString(this.uIDMap.keySet().toArray()));
        } else {
            LPMobileLog.w(TAG, "onRequestHandled NOT IN MAP! " + requestId + ", map = " + Arrays.toString(this.uIDMap.keySet().toArray()));
        }
    }

    public void onSocketClosed() {
        LPMobileLog.d(TAG, "onSocketClosed: sending event to all waiting requests. map = " + Arrays.toString(this.uIDMap.keySet().toArray()));
        for (BaseResponseHandler response : this.uIDMap.values()) {
            response.giveUp();
        }
        this.uIDMap.clear();
    }

    public BaseResponseHandler getRequestIdHandler(String messageType, long requestId) {
        BaseResponseHandler baseResponseHandler = this.uIDMap.get(requestId);
        if (baseResponseHandler == null) {
            LPMobileLog.d(RESPONSE_TAG + TAG, "Getting general response for message type :" + messageType);
            return this.getGeneralHandler(messageType);
        }
        LPMobileLog.d(RESPONSE_TAG + TAG, "Found response in map :" + messageType + " requestId = " + requestId);
        return baseResponseHandler;
    }

    private BaseResponseHandler getGeneralHandler(String messageType) {
        if (this.generalResponseHandler == null) {
            return null;
        }
        return this.generalResponseHandler.createInstance(messageType);
    }

    public void putGeneralHandler(GeneralResponseHandler generalResponseHandler) {
        this.generalResponseHandler = generalResponseHandler;
    }

    @Override
    public void shutDown() {
        this.onSocketClosed();
        this.uIDMap.clear();
        this.mGeneralMap.clear();
    }
}

