/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.liveperson.infra.IDisposable;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.ISocketCallbacks;
import com.liveperson.infra.network.socket.ISocketWrapper;
import com.liveperson.infra.network.socket.ResponseMap;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.SocketStateManager;
import com.liveperson.infra.network.socket.SocketWrapperOK;
import com.liveperson.infra.utils.DispatchQueue;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketHandler
implements ISocketCallbacks,
IDisposable {
    private static final String TAG = SocketHandler.class.getSimpleName();
    private static final int CLOSING_TIMEOUT = 5000;
    public static final int PERIODIC_PING_TIME = 20000;
    public static final int CERTIFICATE_ERROR = 1200;
    private ResponseMap mResponseMap;
    private DispatchQueue mRequestsQueue = new DispatchQueue(TAG + "_Requests");
    private DispatchQueue mResponsesQueue = new DispatchQueue(TAG + "_Responses");
    private ISocketWrapper mSocketWrapper;
    private SocketStateManager mSocketStateManager = new SocketStateManager();
    private Runnable mClosingRunnable = null;

    public SocketHandler(ResponseMap responseMap) {
        this.mResponseMap = responseMap;
    }

    void connect(final SocketConnectionParams connectionParams) {
        this.mRequestsQueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                SocketHandler.this.handleConnect(connectionParams);
            }
        });
    }

    private void handleConnect(SocketConnectionParams connectionParams) {
        SocketState state = this.mSocketStateManager.getState();
        LPMobileLog.d(TAG, "handleConnect with state " + (Object)((Object)state) + ". ");
        switch (state) {
            case OPEN: {
                this.disconnect();
                break;
            }
            case INIT: 
            case ERROR: 
            case CLOSED: {
                this.openConnection(connectionParams);
                break;
            }
        }
    }

    void disconnect() {
        LPMobileLog.d(TAG, "disconnect");
        this.mRequestsQueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                SocketHandler.this.mSocketWrapper.disconnect();
            }
        });
    }

    SocketStateManager getSocketStateManager() {
        return this.mSocketStateManager;
    }

    private void openConnection(SocketConnectionParams connectionParams) {
        LPMobileLog.d(TAG, "openConnection");
        this.mSocketWrapper = new SocketWrapperOK(this);
        try {
            this.mSocketWrapper.connect(connectionParams);
        }
        catch (IllegalArgumentException ie) {
            LPMobileLog.d(TAG, "Error: ", ie);
        }
    }

    public void send(String message) {
        this.mRequestsQueue.postRunnable(new SendMessageRunnable(message));
    }

    public Runnable sendDelayed(String message, long delay) {
        SendMessageRunnable runnable = new SendMessageRunnable(message);
        this.mRequestsQueue.postRunnable(runnable, delay);
        return runnable;
    }

    private void handle(BaseResponseHandler baseResponseHandler, Object valueObject) {
        Object request = baseResponseHandler.getRequest();
        if (request != null) {
            ((BaseSocketRequest)request).dispatchSuccess((Object)valueObject);
        }
        boolean isHandled = baseResponseHandler.handle(valueObject);
        if (request != null && isHandled) {
            this.mResponseMap.onRequestHandled(((BaseSocketRequest)request).getRequestId());
        }
    }

    @Override
    public void onStateChanged(SocketState newState) {
        LPMobileLog.d(TAG, "onStateChanged newState " + newState.name());
        this.mSocketStateManager.setState(newState);
        switch (newState) {
            case CLOSING: {
                this.mClosingRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (SocketHandler.this.mSocketStateManager.getState() == SocketState.CLOSING) {
                            LPMobileLog.d(TAG, "onStateChanged timeout expired on state CLOSING. force closing socket. ");
                            SocketHandler.this.finalizeClosing();
                        }
                    }
                };
                this.mRequestsQueue.postRunnable(this.mClosingRunnable, 5000L);
                break;
            }
            case CLOSED: {
                if (this.mClosingRunnable != null) {
                    this.mRequestsQueue.removeRunnable(this.mClosingRunnable);
                    this.mClosingRunnable = null;
                }
                this.mResponsesQueue.postRunnable(new Runnable(){

                    @Override
                    public void run() {
                        SocketHandler.this.finalizeClosing();
                    }
                });
                break;
            }
        }
    }

    private void finalizeClosing() {
        this.mSocketStateManager.setState(SocketState.CLOSED);
        this.mResponseMap.onSocketClosed();
    }

    @Override
    public void onMessage(final String text) {
        LPMobileLog.d(TAG, "---------------------onMessage---------------------");
        LPMobileLog.d(TAG, "text " + text);
        this.mResponsesQueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                this.parseIncomingData();
            }

            private void parseIncomingData() {
                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(text);
                }
                catch (JSONException e1) {
                    LPMobileLog.e(TAG, "Error converting response to json object! should never happened!", e1);
                }
                if (jsonObject == null) {
                    return;
                }
                String messageType = jsonObject.optString("type", "AbstractResponse");
                int requestId = jsonObject.optInt("reqId", -1);
                BaseResponseHandler baseResponseHandler = SocketHandler.this.mResponseMap.getRequestIdHandler(messageType, requestId);
                String expectedType = this.extractExpectedParsingType(baseResponseHandler);
                LPMobileLog.d("FLOW_RESPONSES_", "extractExpectedParsingType expectedType = " + expectedType + " received messageType = " + messageType);
                if (baseResponseHandler != null && !TextUtils.equals((CharSequence)messageType, (CharSequence)expectedType)) {
                    baseResponseHandler = baseResponseHandler.getResponseByExpectedType(messageType);
                }
                if (baseResponseHandler == null) {
                    LPMobileLog.d(TAG, "Lost response:" + messageType + "(" + requestId + ")");
                    LPMobileLog.i(TAG, "Got response = " + messageType + ", no response handler");
                } else {
                    Object valueObject = null;
                    try {
                        LPMobileLog.i(TAG, "Got response = " + messageType + (baseResponseHandler.getRequest() != null ? " for request " + ((BaseSocketRequest)baseResponseHandler.getRequest()).getRequestName() : ""));
                        valueObject = baseResponseHandler.parse(jsonObject);
                    }
                    catch (Exception e1) {
                        LPMobileLog.e(TAG, "Error parsing response!", e1);
                    }
                    if (valueObject == null) {
                        baseResponseHandler.onParsingError();
                        Object request = baseResponseHandler.getRequest();
                        if (request != null) {
                            ((BaseSocketRequest)request).dispatchError();
                        }
                    } else {
                        SocketHandler.this.handle(baseResponseHandler, valueObject);
                    }
                }
            }

            @Nullable
            private String extractExpectedParsingType(BaseResponseHandler baseResponseHandler) {
                if (baseResponseHandler == null) {
                    return null;
                }
                return baseResponseHandler.getAPIResponseType();
            }
        });
    }

    @Override
    public void onDisconnected(String reason, int code) {
        this.mSocketStateManager.disconnected(reason, code);
    }

    @Override
    public void dispose() {
        this.mRequestsQueue.cleanupQueue();
        this.mResponsesQueue.cleanupQueue();
        this.mRequestsQueue.postRunnable(() -> {
            LPMobileLog.i(TAG, "dispose " + TAG);
            if (this.mSocketWrapper != null) {
                this.mSocketStateManager.dispose();
                this.mRequestsQueue.dispose();
                this.mResponsesQueue.dispose();
                this.mRequestsQueue = null;
                this.mResponsesQueue = null;
                this.mSocketStateManager = null;
                this.mSocketWrapper = null;
            }
        });
    }

    private class SendMessageRunnable
    implements Runnable {
        private final String message;

        public SendMessageRunnable(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            SocketState state = SocketHandler.this.mSocketStateManager.getState();
            if (state == SocketState.OPEN) {
                LPMobileLog.d(TAG, "Sending data: " + this.message);
                SocketHandler.this.mSocketWrapper.send(this.message);
            } else {
                LPMobileLog.w(TAG, "Ignoring message(" + (Object)((Object)SocketHandler.this.mSocketStateManager.getState()) + ") " + this.message);
            }
        }
    }
}

