/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import com.liveperson.infra.log.LPMobileLog;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutor {
    private static final String TAG = ThreadPoolExecutor.class.getSimpleName();
    private static final int THREAD_POOL_SIZE = 5;
    private static final long THREAD_KEEP_ALIVE_TIME = 60L;
    private static ScheduledThreadPoolExecutor mScheduledExecutor;
    private static ExecutorService mExecutor;

    private static void init() {
        if (mExecutor == null) {
            mExecutor = Executors.newFixedThreadPool(5);
        }
    }

    private static void initScheduled() {
        if (mScheduledExecutor == null) {
            mScheduledExecutor = new ScheduledThreadPoolExecutor(1);
            mScheduledExecutor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        }
    }

    public static void execute(Runnable runnable) {
        ThreadPoolExecutor.init();
        mExecutor.execute(runnable);
    }

    public static void executeDelayed(Runnable runnable, long delay) {
        if (delay == 0L) {
            ThreadPoolExecutor.execute(runnable);
        } else {
            ThreadPoolExecutor.initScheduled();
            mScheduledExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
        }
    }

    public static void killAll() {
        try {
            if (mScheduledExecutor != null) {
                LPMobileLog.d(TAG, "Start killing mScheduledExecutor");
                mScheduledExecutor.shutdown();
                mScheduledExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                mScheduledExecutor.shutdownNow();
                LPMobileLog.d(TAG, "Finished killing mScheduledExecutor");
            }
            if (mExecutor != null) {
                LPMobileLog.d(TAG, "Start killing mExecutor");
                mExecutor.shutdown();
                mExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                mExecutor.shutdownNow();
                LPMobileLog.d(TAG, "Finished killing mExecutor");
            }
        }
        catch (InterruptedException e) {
            LPMobileLog.w(TAG, "Error killing Executors", e);
        }
        finally {
            mScheduledExecutor = null;
            mExecutor = null;
        }
    }
}

