package com.liveperson.infra;

import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.liveperson.infra.callbacks.InitLivePersonCallBack;

/**
 * Created by shiranr on 05/07/2016.
 */
public class InitLivePersonProperties {

	private static final String TAG = "InitLivePersonProperties";
	private String mBrandId;
	private InitLivePersonCallBack mInitCallBack;
	private String mAppId;
	private MonitoringInitParams mMonitoringInitParams;
	@Nullable private Interceptors mInterceptors;

	public InitLivePersonProperties(String brandId, String appId, InitLivePersonCallBack initCallBack) {
		mBrandId = brandId;
		mInitCallBack = initCallBack;
		mAppId = appId;
		mMonitoringInitParams = null;
	}

	public InitLivePersonProperties(String brandId, String appId, MonitoringInitParams monitoringInitParams, InitLivePersonCallBack initCallBack) {

		this(brandId, appId, initCallBack);
		mMonitoringInitParams = monitoringInitParams;
	}

	public void addInterceptors(@Nullable Interceptors interceptors) {

		mInterceptors = interceptors;
	}

	public String getBrandId() {
		return mBrandId;
	}

	public InitLivePersonCallBack getInitCallBack() {
		return mInitCallBack;
	}

	public void setInitCallBack(InitLivePersonCallBack initCallBack) {
		mInitCallBack = initCallBack;
	}

	public String getAppId() {
		return mAppId;
	}

	public MonitoringInitParams getMonitoringInitParams() {
		return mMonitoringInitParams;
	}

	public static boolean isValid(InitLivePersonProperties initProperties) {
		return initProperties != null && !TextUtils.isEmpty(initProperties.getBrandId()) && !TextUtils.isEmpty(initProperties.getAppId());
	}

	public boolean isMonitoringParamsValid(){
		return (mMonitoringInitParams != null) && (!TextUtils.isEmpty(getMonitoringInitParams().getAppInstallId()));
	}

	@Nullable
	public Interceptors getInterceptors() {
		return mInterceptors;
	}
}
