package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

import com.liveperson.infra.log.LPMobileLog;

/**
 * Created by ofira on 24/07/2015.
 */
public class ConversationsTable implements BaseTable {

    private static final String TAG = ConversationsTable.class.getSimpleName();

    //Conversation table name
    public static final String TABLE_NAME = "conversations";

    /**
     * Conversations table columns
     */
    public class Key {
        public static final String BRAND_ID = "brand_id";
        public static final String TARGET_ID = "target_id";

        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String END_TIMESTAMP = "end_timestamp";
        public static final String STATE = "state";

        public static final String CLOSE_REASON = "close_reason";
        public static final String UNREAD_MESSAGES_COUNT = "unread_msg_count";
        public static final String REQUEST_ID = "request_id";

        public static final String CSAT_STATUS = "csat_status";
        public static final String TTR_TYPE = "ttr_type";
        public static final String CONVERSATION_ID = "conversation_id";

        public static final String CONCURRENT_REQUESTS_COUNTER = "concurrent_requests_counter";

        // todo Perry, this should replace all 'LAST_SERVER_SEQUENCE' when it comes to conversation
//        public static final String DID_LOAD_MESSAGES = "didLoadMessages";
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        //TODO: Check what are the changes from the DB Version 1
        return new StringBuilder()
                .append("create table ").append(TABLE_NAME).append("(")
                .append(KEY_ID).append(" integer primary key autoincrement,")
                .append(Key.CONVERSATION_ID).append(" text unique,")
                .append(Key.BRAND_ID).append(" text,")
                .append(Key.TARGET_ID).append(" text,")
                .append(Key.UNREAD_MESSAGES_COUNT).append(" integer default -1,")
                .append(Key.START_TIMESTAMP).append(" big int not null,")
                .append(Key.REQUEST_ID).append(" big int,")
                .append(Key.TTR_TYPE).append(" integer,")
                .append(Key.CSAT_STATUS).append(" long default -1,")
                .append(Key.END_TIMESTAMP).append(" long default -1,")
                .append(Key.CLOSE_REASON).append(" integer default -1,")
                .append(Key.CONCURRENT_REQUESTS_COUNTER).append(" integer default 0,")
                .append(Key.STATE).append(" integer,")
                .append(" UNIQUE ( ").append(Key.CONVERSATION_ID).append(") ON CONFLICT IGNORE")
                .append(");")
                .toString();
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 6) {
            LPMobileLog.d(TAG, "**** Migrating from old DB version (" + oldVersion + ") to new DB version (" + newVersion + ") ****");
            // Keeping the older versions migration steps
            String tempConversationsTableName = "conversationsOld";
            db.execSQL("ALTER TABLE " + TABLE_NAME + " RENAME TO " + tempConversationsTableName);

            // Create the updated conversations table
            db.execSQL(getCreateCommand());

            // First copy the necessary values to the new Conversations table
            String replaceConversationsTable = new StringBuilder()
                    .append("insert into " + TABLE_NAME)

                    .append(" (" + Key.CONVERSATION_ID)
                    .append(", " + Key.BRAND_ID)
                    .append(", " + Key.TARGET_ID)
                    .append(", " + Key.UNREAD_MESSAGES_COUNT)
                    .append(", " + Key.START_TIMESTAMP)
                    .append(", " + Key.END_TIMESTAMP)
                    .append(", " + Key.REQUEST_ID)
                    .append(", " + Key.TTR_TYPE)
                    .append(", " + Key.CSAT_STATUS)
                    .append(", " + Key.CLOSE_REASON)
                    .append(", " + Key.CONCURRENT_REQUESTS_COUNTER)
                    .append(", " + Key.STATE + ") ")

                    .append("select conversationId")
                    .append(", brandId")
                    .append(", targetId")
                    .append(", unread_msg")
                    .append(", start_time")
                    .append(", close_time")
                    .append(", " + Key.REQUEST_ID)
                    .append(", " + Key.TTR_TYPE)
                    .append(", showed_csat")
                    .append(", " + Key.CLOSE_REASON)
                    .append(", updating_in_progress_semaphore")
                    .append(", " + Key.STATE)

                    .append(" from " + tempConversationsTableName).toString();

            db.execSQL(replaceConversationsTable);


            db.execSQL(new DialogsTable().getCreateCommand());

            // Now copy the necessary values to the Dialogs table
            String updateDialogsTable = new StringBuilder()
                    .append("insert into " + DialogsTable.TABLE_NAME)

                    .append(" (" + DialogsTable.Key.CONVERSATION_ID)
                    // Migrating with a default value, the conversation + the dialog have same ID
                    .append(", " + DialogsTable.Key.DIALOG_ID)
                    .append(", " + DialogsTable.Key.DIALOG_TYPE)
                    .append(", " + DialogsTable.Key.CHANNEL_TYPE)
                    .append(", " + DialogsTable.Key.BRAND_ID)
                    .append(", " + DialogsTable.Key.TARGET_ID)
                    .append(", " + DialogsTable.Key.ASSIGNED_AGENT_ID)
                    .append(", " + DialogsTable.Key.LAST_SERVER_SEQUENCE)
                    .append(", " + DialogsTable.Key.UNREAD_MESSAGES_COUNT)
                    .append(", " + DialogsTable.Key.START_TIMESTAMP)
                    .append(", " + DialogsTable.Key.END_TIMESTAMP)
                    .append(", " + DialogsTable.Key.REQUEST_ID)
                    .append(", " + DialogsTable.Key.TTR_TYPE)
                    .append(", " + DialogsTable.Key.CSAT_STATUS)
                    .append(", " + DialogsTable.Key.CLOSE_REASON)
                    .append(", " + DialogsTable.Key.STATE)
                    .append(", " + DialogsTable.Key.CONCURRENT_REQUESTS_COUNTER + ") ")

                    .append("select conversationId")
                    // Migrating with a default value, the conversation + the dialog have same ID
                    .append(", conversationId")
                    .append(", 'MAIN' as " + DialogsTable.Key.DIALOG_TYPE)
                    .append(", 'MESSAGING' as " + DialogsTable.Key.CHANNEL_TYPE)
                    .append(", brandId")
                    .append(", targetId")
                    .append(", assignedAgentId")
                    .append(", " + DialogsTable.Key.LAST_SERVER_SEQUENCE)
                    .append(", unread_msg")
                    .append(", start_time")
                    .append(", close_time")
                    .append(", " + DialogsTable.Key.REQUEST_ID)     // TODO, Perry: should we migrate this value into the dialogs table??
                    .append(", " + DialogsTable.Key.TTR_TYPE)
                    .append(", showed_csat")
                    .append(", " + DialogsTable.Key.CLOSE_REASON)
                    .append(", " + DialogsTable.Key.STATE)
                    .append(", updating_in_progress_semaphore")
                    .append(" from " + tempConversationsTableName).toString();

            db.execSQL(updateDialogsTable);

            // Remove temporary table
            db.execSQL("DROP TABLE " + tempConversationsTableName);
        }
    }
}