package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

import com.liveperson.infra.log.LPMobileLog;

/**
 * Created by ofira on 24/07/2015.
 */
public class DialogsTable implements BaseTable {

    private static final String TAG = DialogsTable.class.getSimpleName();

    //Conversation table name
    public static final String TABLE_NAME = "dialogs";

    public class Key {
        public static final String CONVERSATION_ID = "conversation_id";
        public static final String DIALOG_ID = "dialog_id";
        public static final String DIALOG_TYPE = "dialog_type";
        public static final String CHANNEL_TYPE = "channel_type";
        public static final String BRAND_ID = "brand_id";
        public static final String TARGET_ID = "target_id";
        public static final String UNREAD_MESSAGES_COUNT = "unread_msg_count";

        public static final String CLOSE_REASON = "close_reason";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String END_TIMESTAMP = "end_timestamp";
        public static final String CSAT_STATUS = "csat_status";
        public static final String TTR_TYPE = "ttr_type";
        public static final String ASSIGNED_AGENT_ID = "assigned_agent_id";
        public static final String LAST_SERVER_SEQUENCE = "last_server_sequence";
        public static final String REQUEST_ID = "request_id";
        public static final String STATE = "state";
        public static final String CONCURRENT_REQUESTS_COUNTER = "concurrent_requests_counter";
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        //TODO: Check what are the changes from the DB Version 1
        return new StringBuilder()
                .append("create table ").append(TABLE_NAME).append("(")
                .append(KEY_ID).append(" integer primary key autoincrement,")
                .append(Key.DIALOG_ID).append(" text unique,")
                .append(Key.CONVERSATION_ID).append(" text,")
                .append(Key.DIALOG_TYPE).append(" text,")
                .append(Key.CHANNEL_TYPE).append(" text,")
                .append(Key.BRAND_ID).append(" text,")
                .append(Key.TARGET_ID).append(" text,")
                .append(Key.ASSIGNED_AGENT_ID).append(" text,")
                .append(Key.UNREAD_MESSAGES_COUNT).append(" integer default -1,")
                .append(Key.START_TIMESTAMP).append(" big int not null,")
                .append(Key.REQUEST_ID).append(" big int,")
                .append(Key.TTR_TYPE).append(" integer,")
                .append(Key.LAST_SERVER_SEQUENCE).append(" integer default -1,")
                .append(Key.CSAT_STATUS).append(" long default -1,")
                .append(Key.END_TIMESTAMP).append(" long default -1,")
                .append(Key.CLOSE_REASON).append(" integer default -1,")
                .append(Key.CONCURRENT_REQUESTS_COUNTER).append(" integer default 0,")
                .append(Key.STATE).append(" integer,")
                //.append(KEY_UPDATE_IN_PROGRESS_SEMAPHORE).append(" integer,") // todo: Why do we need to save a semaphore??
                .append(" UNIQUE ( ").append(Key.DIALOG_ID).append(") ON CONFLICT IGNORE")
                .append(");")
                .toString();
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion == 6) {
            // Do nothing...
            LPMobileLog.i(TAG, "It's the version of this table's arrival");
        }
    }
}