package com.liveperson.infra.database.transaction_helper;

import android.content.ContentValues;

/**
 * Created by shiranr on 13/01/2016.
 */
public class InsertSQLCommand extends SQLiteCommand {

    private static final String TAG = InsertSQLCommand.class.getSimpleName();
    public InsertSQLCommand(ContentValues contentValues) {
        super(contentValues);
    }

    @Override
    public int getType() {
        return CommandType.INSERT;
    }

	/**
	 * Call this to indicate that the insert operation is completed. This will notify any registered
	 * listener
	 * @param rowId
	 */
	@Override
	public void onInserted(long rowId) {
		if (mListener != null) {
			mListener.onInsertComplete(rowId);
		}
	}

}
