package com.liveperson.infra.database.transaction_helper;

import android.content.ContentValues;

/**
 * Created by shiranr on 13/01/2016.
 */

public abstract class SQLiteCommand {

    private static final String TAG = SQLiteCommand.class.getSimpleName();

	protected SQLiteCommandListener mListener;

    public interface CommandType {
        int INSERT = 0;
        int UPDATE = 1;
        int INSERT_OR_UPDATE = 2;
    }

    private ContentValues mContentValues;

    public SQLiteCommand(ContentValues contentValues) {
        mContentValues = contentValues;
    }

    public ContentValues getContentValues() {
        return mContentValues;
    }

	/**
	 * Set SQLiteCommandListener for operation indication
	 * @param listener
	 */
	public void setListener(SQLiteCommandListener listener){
		mListener = listener;
	}

	public void onInserted(long rowId) {
		// Implement on derived classes if needed
	}

	public abstract int getType();

	public interface SQLiteCommandListener{
		void onInsertComplete(long rowId);
	}
}
