package com.liveperson.infra.log

import android.util.Log

/**
 * Implementation of a Logger that posts everything to the Android System Logs.
 * Default implementation that should be used in all production use-cases.
 * Cannot be used in unit tests.
 */
class AndroidLogger : Logger {

	override fun v(tag: String, message: String) {
		Log.v(tag, message)
	}

	override fun v(tag: String, message: String, exception: Throwable) {
		Log.v(tag, message, exception)
	}

	override fun d(tag: String, message: String) {
		Log.d(tag, message)
	}

	override fun d(tag: String, message: String, exception: Throwable) {
		Log.d(tag, message, exception)
	}

	override fun i(tag: String, message: String) {
		Log.i(tag, message)
	}

	override fun i(tag: String, message: String, exception: Throwable) {
		Log.i(tag, message, exception)
	}

	override fun w(tag: String, message: String) {
		Log.w(tag, message)
	}

	override fun w(tag: String, message: String, exception: Throwable) {
		Log.w(tag, message, exception)
	}

	override fun e(tag: String, message: String) {
		Log.e(tag, message)
	}

	override fun e(tag: String, message: String, exception: Throwable) {
		Log.e(tag, message, exception)
	}

	override fun wtf(tag: String, message: String) {
		Log.wtf(tag, message)
	}

	override fun wtf(tag: String, message: String, exception: Throwable) {
		Log.wtf(tag, message, exception)
	}
}
