/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.LocalBroadcast;

public class InternetConnectionService
implements ShutDown {
    private static final String TAG = InternetConnectionService.class.getSimpleName();
    public static final String BROADCAST_INTERNET_CONNECTION_CONNECTED = "CONNECTION_CONNECTED";
    public static final String BROADCAST_INTERNET_CONNECTION_DISCONNECTED = "CONNECTION_DISCONNECTED";
    private ConnectionReceiver mConnectionReceiver;

    InternetConnectionService() {
        this.registeredReceiver();
    }

    public void registeredReceiver() {
        if (this.mConnectionReceiver == null) {
            this.mConnectionReceiver = new ConnectionReceiver();
            LPMobileLog.d(TAG, "creating new receiver");
        }
        this.mConnectionReceiver.register(Infra.instance.getApplicationContext());
    }

    public void unRegisteredReceiver() {
        if (this.mConnectionReceiver != null) {
            LPMobileLog.d(TAG, "un-registering the receiver");
            try {
                Infra.instance.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mConnectionReceiver);
            }
            catch (IllegalArgumentException e) {
                LPMobileLog.e(TAG, "Failed to un-register connection receiver. Reason: ", e);
            }
            this.mConnectionReceiver = null;
        }
    }

    public static boolean isNetworkAvailable() {
        Context applicationContext = Infra.instance.getApplicationContext();
        if (applicationContext != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)applicationContext.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            boolean b = networkInfo != null && networkInfo.isConnectedOrConnecting();
            LPMobileLog.d(TAG, "isNetworkAvailable: isConnected = " + b);
            LPMobileLog.d(TAG, "isNetworkAvailable: networkInfo = " + networkInfo);
            return b;
        }
        LPMobileLog.d(TAG, "isNetworkAvailable: app context is null!");
        return false;
    }

    @Override
    public void shutDown() {
        this.unRegisteredReceiver();
    }

    private class ConnectionReceiver
    extends BroadcastReceiver {
        private final IntentFilter intentFilter = new IntentFilter();
        private boolean lastConnectionState;

        public ConnectionReceiver() {
            this.intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        }

        public void register(Context context) {
            Intent currentStatus = context.registerReceiver((BroadcastReceiver)this, this.intentFilter);
            this.lastConnectionState = InternetConnectionService.isNetworkAvailable();
            this.onReceive(context, currentStatus);
            LPMobileLog.d(TAG, "RegisteredReceiver, currentStatus = " + currentStatus);
            LPMobileLog.d(TAG, "RegisteredReceiver, lastConnectionState = " + this.lastConnectionState);
        }

        public void onReceive(Context context, Intent intent) {
            String action;
            if (intent != null && (action = intent.getAction()).equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                boolean isConnected = InternetConnectionService.isNetworkAvailable();
                LPMobileLog.d(TAG, "isConnected " + isConnected);
                LPMobileLog.d(TAG, "lastConnectionState " + this.lastConnectionState);
                if (this.lastConnectionState != isConnected) {
                    this.lastConnectionState = isConnected;
                    this.sendUpdateIntent(isConnected);
                    LPMobileLog.i(TAG, "Getting broadcast with action " + intent.getAction() + ", connected = " + this.lastConnectionState);
                }
            }
        }

        private void sendUpdateIntent(boolean isConnected) {
            String intentAction = isConnected ? InternetConnectionService.BROADCAST_INTERNET_CONNECTION_CONNECTED : InternetConnectionService.BROADCAST_INTERNET_CONNECTION_DISCONNECTED;
            LocalBroadcast.sendBroadcast(intentAction);
        }
    }
}

