/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database.tables;

import android.database.sqlite.SQLiteDatabase;
import com.liveperson.infra.database.tables.BaseTable;

public class FilesTable
implements BaseTable {
    private static final String TAG = FilesTable.class.getSimpleName();
    public static final String FILES_TABLE = "files";
    public static final String KEY_ID_AS_VALUE = "file_row_id";
    public static final String KEY_PREVIEW = "preview";
    public static final String KEY_SWIFT_PATH = "swiftPath";
    public static final String KEY_FILE_TYPE = "fileType";
    public static final String KEY_LOCAL_URL = "localUrl";
    public static final String KEY_LOAD_STATUS = "loadStatus";
    public static final String KEY_RELATED_MESSAGE_ROW_ID = "relatedMessageRowID";
    public static final String KEY_LOCAL_URL_UPDATE_TIMESTAMP = "localUrlTimestamp";

    @Override
    public String getCreateCommand() {
        return "create table " + FILES_TABLE + "(" + "_id" + " integer primary key autoincrement," + KEY_PREVIEW + " text," + KEY_SWIFT_PATH + " text," + KEY_FILE_TYPE + " text," + KEY_LOCAL_URL + " text," + KEY_LOAD_STATUS + " integer," + KEY_LOCAL_URL_UPDATE_TIMESTAMP + " big int," + KEY_RELATED_MESSAGE_ROW_ID + " integer default -1);";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 4) {
            db.execSQL(this.getCreateCommand());
        }
    }

    @Override
    public String getName() {
        return TAG;
    }

    public static String[] getProjection() {
        return new String[]{"_id", KEY_PREVIEW, KEY_SWIFT_PATH, KEY_FILE_TYPE, KEY_LOCAL_URL, KEY_RELATED_MESSAGE_ROW_ID};
    }

    public static enum LoadStatus {
        NOT_STARTED,
        PROCESSING,
        REQUESTING_URL,
        UPLOADING,
        DOWNLOADING,
        COMPLETED,
        FAILED,
        PREVIEW_ERROR;

    }
}

