/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import android.text.TextUtils;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.ISocketCallbacks;
import com.liveperson.infra.network.socket.ISocketWrapper;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.utils.TlsUtil;
import com.liveperson.infra.utils.Utils;
import java.net.ProtocolException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import okhttp3.CertificatePinner;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class SocketWrapperOK
implements ISocketWrapper {
    private static final String TAG = "SocketWrapperOK";
    private WebSocket mWebSocket;
    private ISocketCallbacks mSocketCallbacks;

    public SocketWrapperOK(ISocketCallbacks socketCallbacks) {
        this.mSocketCallbacks = socketCallbacks;
        this.mSocketCallbacks.onStateChanged(SocketState.INIT);
    }

    @Override
    public void connect(SocketConnectionParams connectionParams) throws IllegalArgumentException {
        Request.Builder requestBuilder = new Request.Builder().url(connectionParams.getUrl());
        for (Map.Entry<String, String> header : connectionParams.getHeaders().entrySet()) {
            requestBuilder.addHeader(header.getKey(), header.getValue());
        }
        Request request = requestBuilder.build();
        WebSocketCallbacks listener = new WebSocketCallbacks();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        TlsUtil.enableTls12ForKitKat(clientBuilder);
        clientBuilder.pingInterval(20000L, TimeUnit.MILLISECONDS);
        if (connectionParams.getCertificatePinningKeys() != null) {
            CertificatePinner.Builder builder = new CertificatePinner.Builder();
            for (String key : connectionParams.getCertificatePinningKeys()) {
                LPMobileLog.d(TAG, "Pinning Key: " + key);
                if (!Utils.isValidCertificateKey(key)) continue;
                builder.add(request.url().host(), new String[]{key});
            }
            CertificatePinner certificatePinner = builder.build();
            clientBuilder.certificatePinner(certificatePinner);
        }
        OkHttpClient client = clientBuilder.build();
        LPMobileLog.d(TAG, "Socket connecting.... " + connectionParams.getUrl() + (connectionParams.getCertificatePinningKeys() != null ? "with Pinning Keys " + TextUtils.join((CharSequence)",", connectionParams.getCertificatePinningKeys()) : " with no Pinning Keys"));
        this.mWebSocket = client.newWebSocket(request, (WebSocketListener)listener);
        this.mSocketCallbacks.onStateChanged(SocketState.CONNECTING);
    }

    @Override
    public void disconnect() {
        LPMobileLog.d(TAG, "Socket disconnect was called");
        if (this.mWebSocket != null) {
            this.mSocketCallbacks.onStateChanged(SocketState.CLOSING);
            this.mWebSocket.close(1000, "Disconnected by device");
        }
    }

    @Override
    public void send(String message) {
        LPMobileLog.d(TAG, "Socket send " + message);
        if (this.mWebSocket != null) {
            this.mWebSocket.send(message);
        }
    }

    private class WebSocketCallbacks
    extends WebSocketListener {
        private WebSocketCallbacks() {
        }

        public void onOpen(WebSocket webSocket, Response response) {
            LPMobileLog.i(SocketWrapperOK.TAG, "onOpen() called with: response = [" + response + "]");
            SocketWrapperOK.this.mSocketCallbacks.onStateChanged(SocketState.OPEN);
        }

        public void onMessage(WebSocket webSocket, String text) {
            LPMobileLog.i(SocketWrapperOK.TAG, "---- Socket onMessage callback with text: " + text);
            SocketWrapperOK.this.mSocketCallbacks.onMessage(text);
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            LPMobileLog.i(SocketWrapperOK.TAG, "Socket onMessage callback with ByteString");
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            LPMobileLog.i(SocketWrapperOK.TAG, "onClosing() called with: code = [" + code + "], reason = [" + reason + "]");
            SocketWrapperOK.this.mSocketCallbacks.onDisconnected(reason, code);
            SocketWrapperOK.this.mSocketCallbacks.onStateChanged(SocketState.CLOSING);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            LPMobileLog.i(SocketWrapperOK.TAG, "onClosed() called with: code = [" + code + "], reason = [" + reason + "]");
            SocketWrapperOK.this.mSocketCallbacks.onStateChanged(SocketState.CLOSED);
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            String errorMessage = t != null ? t.getMessage() : "";
            LPMobileLog.i(SocketWrapperOK.TAG, "onFailure() called with: webSocket = [" + webSocket + "], throwable = [" + t + "], response = [" + response + "]ErrorMessage = " + errorMessage);
            SocketWrapperOK.this.mSocketCallbacks.onStateChanged(SocketState.CLOSED);
            if (t instanceof SSLPeerUnverifiedException) {
                SocketWrapperOK.this.mSocketCallbacks.onDisconnected(t.getMessage(), 1200);
            } else if (t instanceof ProtocolException && !errorMessage.isEmpty() && errorMessage.contains("HTTP_PROXY_AUTH (407)")) {
                SocketWrapperOK.this.mSocketCallbacks.onDisconnected("identity token is invalid", 4407);
            }
        }
    }
}

