/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.statemachine;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.statemachine.interfaces.IEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.infra.statemachine.interfaces.IStateMachineExecutor;

public abstract class BaseStateMachine
implements IStateMachine,
ShutDown {
    private static String TAG;
    protected IState activeState = null;
    private IStateMachineExecutor mStateMachineExecutor;

    protected BaseStateMachine(String tag) {
        TAG = tag;
    }

    @Override
    public String getTag() {
        return TAG;
    }

    public void initActiveState(IState state) {
        this.activeState = state;
    }

    public IState activeState() {
        return this.activeState;
    }

    @Override
    public void setStateMachineExecutor(IStateMachineExecutor stateMachineExecutor) {
        this.mStateMachineExecutor = stateMachineExecutor;
    }

    @Override
    public void postEvent(IEvent event) {
        this.mStateMachineExecutor.post(event);
    }

    @Override
    public Runnable postDelayEvent(IEvent event, long delay) {
        return this.mStateMachineExecutor.schedule(event, delay);
    }

    public void changeStateAndPassEvent(IState nextState, IEvent ev) {
        this.changeState(nextState);
        this.apply(ev);
    }

    public void cancelDelayedEvent(Runnable delayedTask) {
        this.mStateMachineExecutor.cancel(delayedTask);
    }

    @Override
    public void apply(IEvent event) {
        LPMobileLog.d(TAG, this.activeState().toString() + " <-<- " + event.toString());
        event.accept(this.activeState());
    }

    public void changeState(IState nextState) {
        this.activeState.actionOnExit();
        LPMobileLog.d(TAG, this.activeState + " -> " + nextState);
        this.activeState = nextState;
        this.activeState.actionOnEntry();
    }

    @Override
    public void shutDown() {
        this.mStateMachineExecutor.shutdown();
    }

    public boolean isInitialized() {
        return this.mStateMachineExecutor.isInitialized();
    }
}

