/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import java.util.Locale;

public class LocaleUtils {
    private static LocaleUtils instance;
    private String engagementLanguageCode;
    private String language;
    private String country;
    private Locale locale;

    private LocaleUtils() {
    }

    public static LocaleUtils getInstance() {
        if (instance == null) {
            instance = new LocaleUtils();
        }
        return instance;
    }

    public void init(Context context) {
        Resources resources = context.getResources();
        this.country = resources.getConfiguration().locale.getCountry();
        this.locale = Build.VERSION.SDK_INT >= 24 ? resources.getConfiguration().getLocales().get(0) : resources.getConfiguration().locale;
        this.language = this.getLanguageCode(this.locale.getLanguage());
    }

    private String getLanguageCode(String languageCode) {
        if (languageCode.equalsIgnoreCase("iw")) {
            return "he";
        }
        if (languageCode.equalsIgnoreCase("in")) {
            return "id";
        }
        if (languageCode.equalsIgnoreCase("ji")) {
            return "yi";
        }
        return languageCode;
    }

    public void setEngagementLanguageCode(String engagementLanguageCode) {
        this.engagementLanguageCode = engagementLanguageCode;
    }

    public void clearEngagementLanguageCode() {
        this.engagementLanguageCode = null;
    }

    public String getLocaleCode() {
        if (!TextUtils.isEmpty((CharSequence)this.engagementLanguageCode)) {
            return this.engagementLanguageCode;
        }
        return this.language + "-" + this.country;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

