/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.Build;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.Tls12SocketFactory;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class TlsUtil {
    private static final String TAG = "TlsUtil";
    private static final String TLS_1_2 = "TLSv1.2";

    public static void enableTls12ForKitKat(OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT == 19) {
            try {
                SSLContext sc = SSLContext.getInstance(TLS_1_2);
                sc.init(null, null, null);
                client.sslSocketFactory((SSLSocketFactory)new Tls12SocketFactory(sc.getSocketFactory()));
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                client.connectionSpecs(specs);
            }
            catch (Exception e) {
                LPMobileLog.e(TAG, "Error while setting TLS 1.2", e);
            }
        }
    }
}

