/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import com.liveperson.infra.managers.PreferenceManager;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class UniqueID {
    private static final String TAG = UniqueID.class.getSimpleName();
    private static final String UNIQUE_KEY = "unique_key";
    private static volatile AtomicLong mAtomicLong;
    private static PreferenceManager mPreferenceManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static long getUniqueID() {
        if (mAtomicLong == null) {
            Class<UniqueID> clazz = UniqueID.class;
            // MONITORENTER : com.liveperson.infra.utils.UniqueID.class
            if (mAtomicLong == null) {
                long lastUniqueId = mPreferenceManager.getLongValue(UNIQUE_KEY, TAG, 0L);
                mAtomicLong = new AtomicLong(lastUniqueId);
            }
            // MONITOREXIT : clazz
        }
        long l = mAtomicLong.incrementAndGet();
        mPreferenceManager.setLongValue(UNIQUE_KEY, TAG, l);
        return l;
    }

    public static String createUniqueMessageEventId() {
        return UUID.randomUUID().toString();
    }

    static {
        mPreferenceManager = PreferenceManager.getInstance();
    }
}

