/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.res.Resources;
import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;
import okio.ByteString;

public class Utils {
    private static final String TAG = Utils.class.getSimpleName();
    public static final String SHA256 = "sha256/";
    public static final String SHA1 = "sha1/";

    public static boolean isValidCertificateKey(String key) {
        ByteString hash;
        if (TextUtils.isEmpty((CharSequence)key)) {
            LPMobileLog.d(TAG, "Certificate key is empty");
            return false;
        }
        if (key.startsWith(SHA1)) {
            hash = ByteString.decodeBase64((String)key.substring(SHA1.length()));
        } else if (key.startsWith(SHA256)) {
            hash = ByteString.decodeBase64((String)key.substring(SHA256.length()));
        } else {
            LPMobileLog.w(TAG, "Key must start with 'sha256/' or 'sha1/'");
            return false;
        }
        if (hash == null) {
            LPMobileLog.w(TAG, "isValidCertificateKey: key must be base64");
            return false;
        }
        return true;
    }

    public static float tryParse(Object numberAsObject, float defaultValue) {
        if (numberAsObject == null) {
            return defaultValue;
        }
        float intValue = defaultValue;
        try {
            intValue = Float.valueOf(numberAsObject.toString()).floatValue();
        }
        catch (NumberFormatException e) {
            LPMobileLog.e(TAG, "Exception parsing " + numberAsObject, e);
        }
        return intValue;
    }

    public static int tryParse(Object numberAsObject, int defaultValue) {
        if (numberAsObject == null) {
            return defaultValue;
        }
        int intValue = defaultValue;
        try {
            intValue = Integer.valueOf(numberAsObject.toString());
        }
        catch (NumberFormatException e) {
            LPMobileLog.e(TAG, "Exception parsing " + numberAsObject, e);
        }
        return intValue;
    }

    public static Resources getResources() {
        return Infra.instance.getApplicationContext().getResources();
    }

    public static byte[] hexStringToByteArray(String string2) {
        int len = string2.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(string2.charAt(i), 16) << 4) + Character.digit(string2.charAt(i + 1), 16));
        }
        return data;
    }
}

