package com.liveperson.infra.network.http.body;

import org.json.JSONObject;

/**
 * Created by ofira on 12/11/2015.
 */
public class LPJSONObjectBody extends HttpStringRequestBody {

    private static final String TAG = LPJSONObjectBody.class.getSimpleName();
    private static final String CONTENT_TYPE = "application/json";
    private JSONObject mJsonObject;

    public LPJSONObjectBody(JSONObject jsonObject) {
        mJsonObject = jsonObject;
    }

    @Override
    public String get() {
        if(mJsonObject != null){
            return mJsonObject.toString();
        }
        return "";
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }
}
