/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import android.text.TextUtils;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.network.socket.ResponseMap;
import com.liveperson.infra.network.socket.SocketHandler;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.SocketStateManager;
import com.liveperson.infra.network.socket.state.SocketStateListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import java.util.HashMap;
import java.util.Map;

public class SocketManager
implements ShutDown {
    private static final String TAG = SocketManager.class.getSimpleName();
    private final Object mSyncObject = new Object();
    private final ResponseMap mResponseMap = new ResponseMap();
    private Map<String, SocketHandler> mSocketHandlersMap = new HashMap<String, SocketHandler>();
    private static volatile SocketManager Instance = null;

    private SocketManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketManager getInstance() {
        if (Instance != null) return Instance;
        Class<SocketManager> clazz = SocketManager.class;
        synchronized (SocketManager.class) {
            if (Instance != null) return Instance;
            Instance = new SocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    public void connect(SocketConnectionParams connectionParams) {
        if (TextUtils.isEmpty((CharSequence)connectionParams.getUrl())) {
            LPMobileLog.e(TAG, "Can't connect to empty url");
            return;
        }
        LPMobileLog.i(TAG, "connecting to socket");
        SocketHandler socketHandler = this.obtainSocket(connectionParams.getUrl());
        socketHandler.connect(connectionParams);
    }

    @Deprecated
    public void connect(String url, int timeout) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            LPMobileLog.e(TAG, "Can't connect to empty url");
            return;
        }
        LPMobileLog.i(TAG, "connecting to socket");
        SocketConnectionParams params = new SocketConnectionParams(url, timeout);
        this.connect(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketHandler obtainSocket(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            LPMobileLog.e(TAG, "Can't obtain socket! url is empty");
            return null;
        }
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                socketHandler = new SocketHandler(this.mResponseMap);
                this.mSocketHandlersMap.put(url, socketHandler);
            }
            return socketHandler;
        }
    }

    public void send(BaseSocketRequest baseSocketRequest) {
        SocketHandler socketHandler = this.getSocketHandler(baseSocketRequest);
        if (socketHandler != null) {
            LPMobileLog.i(TAG, "Sending request " + baseSocketRequest.getRequestName());
            String data = baseSocketRequest.getData();
            socketHandler.send(data);
        }
    }

    public Runnable send(BaseSocketRequest baseSocketRequest, long delay) {
        SocketHandler socketHandler = this.getSocketHandler(baseSocketRequest);
        if (socketHandler != null) {
            return socketHandler.sendDelayed(baseSocketRequest.getData(), delay);
        }
        LPMobileLog.d(TAG, "Can't schedule send delayed SocketRequest");
        return null;
    }

    private SocketHandler getSocketHandler(BaseSocketRequest baseSocketRequest) {
        if (baseSocketRequest == null) {
            LPMobileLog.e(TAG, "can't get SocketHandler with null request");
            return null;
        }
        LPMobileLog.d(TAG, "getSocketHandler req id " + baseSocketRequest.getRequestId());
        BaseResponseHandler responseHandler = baseSocketRequest.getResponseHandler();
        if (responseHandler != null) {
            LPMobileLog.d(TAG, "getResponseHandler for request " + baseSocketRequest.getRequestId() + " is not null");
            responseHandler.init(baseSocketRequest);
            this.mResponseMap.putRequestIdHandler(baseSocketRequest.getRequestId(), responseHandler);
        }
        return this.obtainSocket(baseSocketRequest.getSocketUrl());
    }

    public void cancelDelayedRequest(BaseSocketRequest baseSocketRequest, Runnable request) {
        if (baseSocketRequest == null) {
            LPMobileLog.e(TAG, "Can't run null request!");
            return;
        }
        SocketHandler socketHandler = this.obtainSocket(baseSocketRequest.getSocketUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killSocket(String url) {
        LPMobileLog.i(TAG, "kill socket");
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                return;
            }
            socketHandler.disconnect();
            socketHandler.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String url) {
        LPMobileLog.d(TAG, "disconnect " + url);
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                return;
            }
            socketHandler.disconnect();
        }
    }

    @Override
    public void shutDown() {
        LPMobileLog.i(TAG, "Shutting down all");
        for (String connectionUrl : this.mSocketHandlersMap.keySet()) {
            this.killSocket(connectionUrl);
        }
        this.mSocketHandlersMap.clear();
        this.mResponseMap.shutDown();
        Instance = null;
    }

    public void registerToSocketState(String url, SocketStateListener callback) {
        SocketHandler socketHandler = this.obtainSocket(url);
        if (socketHandler != null) {
            socketHandler.getSocketStateManager().register(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFromSocketState(String url, SocketStateListener callback) {
        SocketHandler socketHandler;
        Object object = this.mSyncObject;
        synchronized (object) {
            socketHandler = this.mSocketHandlersMap.get(url);
        }
        if (socketHandler != null) {
            socketHandler.getSocketStateManager().unregister(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketState getSocketState(String url) {
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                return SocketState.INIT;
            }
            SocketStateManager socketStateManager = socketHandler.getSocketStateManager();
            if (socketStateManager == null) {
                return SocketState.INIT;
            }
            return socketStateManager.getState();
        }
    }

    public void putGeneralHandlerMap(GeneralResponseHandler generalResponseHandler) {
        this.mResponseMap.putGeneralHandler(generalResponseHandler);
    }
}

