/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.media.SoundPool;
import android.os.Build;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.controller.PlayingAudioManager;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.DetectHeadsetUnpluggedBroadcastReceiver;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.UniqueID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class LPAudioUtils {
    public static final String TAG = "LPAudioUtils";
    private final File mFilesFolder;
    public static String VOICE_FOLDER = "voice/";
    private static final String AUDIO_RECORDING_STARTED_BROADCAST = "AUDIO_RECORDING_STARTED_BROADCAST";
    private static final String AUDIO_RECORDING_STOPPED_BROADCAST = "AUDIO_RECORDING_STOPPED_BROADCAST";
    private final HashMap<String, PlaybackCallback> mCallbacks;
    private SoundPool mSoundPool;
    @Nullable
    private LPMediaPlayer mMediaPlayer;
    @Nullable
    private MediaRecorder mMediaRecorder;
    private File mTempRecordedAudioFile;
    private RecordingResultCallback recordingCallback;
    private PlayingAudioManager mPlayingAudioManager;
    private AudioManager mAudioManager;
    private boolean mOtherAudioActive = false;
    private DetectHeadsetUnpluggedBroadcastReceiver mDetectHeadsetUnpluggedBroadcastReceiver = new DetectHeadsetUnpluggedBroadcastReceiver(){

        @Override
        protected void onUnpluggedHeadset() {
            LPAudioUtils.this.mPlayingAudioManager.stopAllCurrentlyPlaying();
            LPAudioUtils.this.stopPlayback();
        }
    };

    public LPAudioUtils() {
        this.mSoundPool = Build.VERSION.SDK_INT >= 21 ? new SoundPool.Builder().setMaxStreams(5).build() : new SoundPool(5, 0, 0);
        this.mCallbacks = new HashMap();
        this.mFilesFolder = Infra.instance.getApplicationContext().getFilesDir();
        this.mPlayingAudioManager = new PlayingAudioManager();
        this.mAudioManager = (AudioManager)Infra.instance.getApplicationContext().getSystemService("audio");
    }

    @Nullable
    private MediaRecorder initMediaRecorder() {
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.release();
        }
        MediaRecorder mediaRecorder = new MediaRecorder();
        mediaRecorder.setAudioChannels(1);
        mediaRecorder.setAudioSource(1);
        mediaRecorder.setOutputFormat(2);
        mediaRecorder.setAudioEncoder(3);
        mediaRecorder.setAudioSamplingRate(16000);
        return mediaRecorder;
    }

    @Nullable
    private LPMediaPlayer initMediaPlayer(String callbackId, String localFile, MediaPlayer.OnCompletionListener onCompletionListener) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
        LPMediaPlayer mediaPlayer = new LPMediaPlayer(callbackId, localFile);
        mediaPlayer.setOnCompletionListener(onCompletionListener);
        return mediaPlayer;
    }

    public LPRecorderStatus startRecording(String filename, int maxDurationMs, RecordingResultCallback recordingResultCallback) {
        boolean isAudioRecordingPermissionGranted;
        LPMobileLog.d(TAG, "startRecording: start recording with max duration (ms) : " + maxDurationMs);
        Context appContext = Infra.instance.getApplicationContext();
        LPRecorderStatus recorderStatus = LPRecorderStatus.PermissionDenied;
        boolean bl = isAudioRecordingPermissionGranted = ContextCompat.checkSelfPermission((Context)appContext, (String)"android.permission.RECORD_AUDIO") == 0;
        if (!isAudioRecordingPermissionGranted) {
            return recorderStatus;
        }
        recorderStatus = LPRecorderStatus.Failed;
        this.mTempRecordedAudioFile = new File(this.getVoiceFolder(), filename);
        this.recordingCallback = recordingResultCallback;
        this.mMediaRecorder = this.initMediaRecorder();
        if (this.mMediaRecorder == null) {
            return recorderStatus;
        }
        boolean didStartRecording = false;
        this.mMediaRecorder.setOutputFile(this.mTempRecordedAudioFile.getPath());
        this.mMediaRecorder.setMaxDuration(maxDurationMs);
        this.mMediaRecorder.setOnInfoListener(new MediaRecorder.OnInfoListener(){

            public void onInfo(MediaRecorder mediaRecorder, int what, int extra) {
                if (what == 800) {
                    LPMobileLog.d(LPAudioUtils.TAG, "onInfo: maximum recoding time reached. Stop the recording and call the callback");
                    LPAudioUtils.this.stopRecording(new ICallback<String, Exception>(){

                        @Override
                        public void onSuccess(String audioFilePath) {
                            if (LPAudioUtils.this.recordingCallback != null) {
                                LPAudioUtils.this.recordingCallback.onMaxRecordingDurationReached(audioFilePath);
                                LPAudioUtils.this.recordingCallback = null;
                            }
                        }

                        @Override
                        public void onError(Exception exception) {
                            if (LPAudioUtils.this.recordingCallback != null) {
                                LPAudioUtils.this.recordingCallback.onMaxRecordingDurationReached(null);
                                LPAudioUtils.this.recordingCallback = null;
                            }
                        }
                    });
                }
            }
        });
        try {
            this.pauseExternalAudio();
            this.mMediaRecorder.prepare();
            this.mMediaRecorder.start();
            didStartRecording = true;
        }
        catch (Throwable exception) {
            LPMobileLog.e(TAG, "failed to stop audio record", exception);
        }
        if (didStartRecording) {
            LocalBroadcast.sendBroadcast(AUDIO_RECORDING_STARTED_BROADCAST);
            recorderStatus = LPRecorderStatus.Started;
        }
        return recorderStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(ICallback<String, Exception> resultCallback) {
        LPMobileLog.d(TAG, "stopRecording: stop recording");
        if (!this.isRecording() || this.mTempRecordedAudioFile == null || this.mMediaRecorder == null) {
            if (resultCallback != null) {
                resultCallback.onError(new Exception("missing recorded file"));
            }
            return;
        }
        String tempAudioFilePath = this.mTempRecordedAudioFile.getPath();
        LPMobileLog.d(TAG, "stopRecording: recording file path: " + tempAudioFilePath);
        try {
            this.mMediaRecorder.stop();
            this.mMediaRecorder.release();
            this.continueExternalAudio();
            if (resultCallback != null) {
                resultCallback.onSuccess(tempAudioFilePath);
            }
            if (this.recordingCallback != null) {
                this.recordingCallback.onRecordingInterrupted(tempAudioFilePath);
            }
            LocalBroadcast.sendBroadcast(AUDIO_RECORDING_STOPPED_BROADCAST);
        }
        catch (IllegalStateException e) {
            LPMobileLog.e(TAG, "failed to stop audio record", e);
        }
        finally {
            this.mMediaRecorder = null;
            this.mTempRecordedAudioFile = null;
            this.recordingCallback = null;
        }
    }

    public static void getDuration(String filePath, final ICallback<Integer, Exception> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            resultCallback.onError(new Exception("file path is empty"));
            return;
        }
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            mediaPlayer.setDataSource(filePath);
            mediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    resultCallback.onSuccess(mp.getDuration());
                }
            });
            mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            LPMobileLog.w(TAG, "getDuration: error getting duration of file " + filePath, e);
            resultCallback.onError(e);
        }
    }

    public void bindPlayingAudio(String callbackId, PlaybackCallback playbackCallback) {
        this.mCallbacks.put(callbackId, playbackCallback);
    }

    public void playAudio(final String audioFileUrl, String callbackId, PlaybackCallback playbackCallback) {
        if (playbackCallback == null) {
            return;
        }
        if (this.mMediaPlayer != null) {
            PlaybackCallback callback;
            if (this.mMediaPlayer.isPlaying(audioFileUrl)) {
                return;
            }
            if (this.mMediaPlayer.getLocalFileUrl().equals(audioFileUrl)) {
                this.pauseExternalAudio();
                this.mMediaPlayer.start();
                playbackCallback.onPlaybackStarted(audioFileUrl, this.mMediaPlayer.getDuration());
                return;
            }
            if (!this.mMediaPlayer.getLocalFileUrl().equals(audioFileUrl) && this.mCallbacks.containsKey(this.mMediaPlayer.callbackId) && (callback = this.mCallbacks.remove(this.mMediaPlayer.callbackId)) != null) {
                callback.onPlaybackCompleted(false, this.mMediaPlayer.getLocalFileUrl());
            }
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if (this.isRecording()) {
            this.stopRecording(null);
        }
        if (TextUtils.isEmpty((CharSequence)audioFileUrl)) {
            playbackCallback.onPlaybackCompleted(false, audioFileUrl);
            return;
        }
        File tempPlayedAudioFile = new File(audioFileUrl);
        if (tempPlayedAudioFile.exists()) {
            this.mCallbacks.put(callbackId, playbackCallback);
            this.mMediaPlayer = this.initMediaPlayer(callbackId, audioFileUrl, new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (!(mp instanceof LPMediaPlayer)) {
                        return;
                    }
                    LPMediaPlayer mediaPlayer = (LPMediaPlayer)mp;
                    PlaybackCallback callback = (PlaybackCallback)LPAudioUtils.this.mCallbacks.remove(mediaPlayer.getCallbackId());
                    String _audioFileUrl = audioFileUrl;
                    if (mediaPlayer == LPAudioUtils.this.mMediaPlayer) {
                        LPAudioUtils.this.cleanupPlayback();
                        _audioFileUrl = mediaPlayer.getLocalFileUrl();
                        LPMobileLog.d(LPAudioUtils.TAG, "Playback completed: " + _audioFileUrl);
                    }
                    if (callback != null) {
                        callback.onPlaybackCompleted(true, _audioFileUrl);
                    }
                }
            });
            if (this.mMediaPlayer == null) {
                tempPlayedAudioFile = null;
                return;
            }
            try {
                this.mMediaPlayer.setDataSource(audioFileUrl);
                this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                    public void onPrepared(MediaPlayer mp) {
                        if (LPAudioUtils.this.mMediaPlayer == mp) {
                            LPAudioUtils.this.pauseExternalAudio();
                            mp.start();
                            LPMobileLog.d(LPAudioUtils.TAG, "onPrepared: Registering to detect unplugged headset");
                            IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
                            Infra.instance.getApplicationContext().registerReceiver((BroadcastReceiver)LPAudioUtils.this.mDetectHeadsetUnpluggedBroadcastReceiver, intentFilter);
                            PlaybackCallback callback = (PlaybackCallback)LPAudioUtils.this.mCallbacks.get(LPAudioUtils.this.mMediaPlayer.getCallbackId());
                            if (callback != null) {
                                callback.onPlaybackStarted(audioFileUrl, mp.getDuration());
                            }
                        }
                    }
                });
                this.mMediaPlayer.prepareAsync();
            }
            catch (IOException e) {
                LPMobileLog.e(TAG, "Exception while opening data source with media player.", e);
            }
        }
    }

    @Nullable
    public String getVoiceFolder() {
        File outgoingAudioFolder = new File(this.mFilesFolder + "/" + VOICE_FOLDER);
        if (!outgoingAudioFolder.exists() && !outgoingAudioFolder.mkdirs()) {
            LPMobileLog.e(TAG, "getVoiceFolder: Image folder could not be created");
            return null;
        }
        return outgoingAudioFolder.getPath();
    }

    private void cleanupPlayback() {
        LPMediaPlayer mp = this.mMediaPlayer;
        this.mMediaPlayer = null;
        if (mp != null) {
            mp.stop();
            mp.release();
            this.continueExternalAudio();
            try {
                Infra.instance.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                LPMobileLog.w(TAG, "cleanupPlayback: receiver is not registered", e);
            }
            this.mCallbacks.remove(mp.getCallbackId());
        }
    }

    public boolean isRecording() {
        return this.mTempRecordedAudioFile != null && this.mMediaRecorder != null;
    }

    public int getCurrentPlayingLocation() {
        int location = 0;
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            location = this.mMediaPlayer.getCurrentPosition();
        }
        return location;
    }

    public int getCurrentPlayingDuration() {
        int duration = -1;
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            duration = this.mMediaPlayer.getDuration();
        }
        return duration;
    }

    private void playSound(String audioFilePath) {
        final Integer soundId = this.mSoundPool.load(audioFilePath, 1);
        final int currentVolume = this.getCurrentVolume();
        this.mSoundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (sampleId == soundId) {
                    soundPool.play(soundId.intValue(), (float)currentVolume, (float)currentVolume, 1, 0, 1.0f);
                }
            }
        });
    }

    private int getCurrentVolume() {
        Context appContext = Infra.instance.getApplicationContext();
        AudioManager audioManager = (AudioManager)appContext.getSystemService("audio");
        int currentVolume = audioManager.getStreamVolume(5);
        return currentVolume;
    }

    public void playSound(int resourceId) {
        final Integer soundId = this.mSoundPool.load(Infra.instance.getApplicationContext(), resourceId, 1);
        final int currentVolume = this.getCurrentVolume();
        this.mSoundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (sampleId == soundId) {
                    soundPool.play(soundId.intValue(), (float)currentVolume, (float)currentVolume, 1, 0, 1.0f);
                }
            }
        });
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            PlaybackCallback callback;
            if (this.mMediaPlayer.isCurrentlyPlaying() && this.mMediaPlayer.getLocalFileUrl() != null && this.mMediaPlayer.callbackId != null && this.mCallbacks.containsKey(this.mMediaPlayer.callbackId) && (callback = this.mCallbacks.remove(this.mMediaPlayer.callbackId)) != null) {
                callback.onPlaybackCompleted(false, this.mMediaPlayer.getLocalFileUrl());
            }
            this.cleanupPlayback();
        }
    }

    public PlayingAudioManager getPlayingAudioManager() {
        return this.mPlayingAudioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveByteArrayToDisk(byte[] fileByteArray) {
        File filePath = new File(this.getVoiceFolder(), LPAudioUtils.generateVoiceFileName());
        LPMobileLog.d(TAG, "saveByteArrayToDisk: filePath: " + filePath.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(fileByteArray);
        }
        catch (FileNotFoundException e) {
            LPMobileLog.e(TAG, "saveByteArrayToDisk: File not found", e);
            String string2 = null;
            return string2;
        }
        catch (IOException e) {
            LPMobileLog.e(TAG, "saveByteArrayToDisk: IOException", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LPMobileLog.e(TAG, "saveByteArrayToDisk: error closing file", e);
                return null;
            }
        }
        LPMobileLog.d(TAG, "saveByteArrayToDisk: file absolute path: " + filePath.getAbsolutePath());
        return filePath.getAbsolutePath();
    }

    public static String generateVoiceFileName() {
        return UniqueID.createUniqueMessageEventId() + ".m4a";
    }

    private void pauseExternalAudio() {
        if (this.mAudioManager.isMusicActive()) {
            this.mOtherAudioActive = true;
            LPMobileLog.d(TAG, "pauseExternalAudio: other audio is playing. Pausing it...");
            KeyEvent event = new KeyEvent(0, 127);
            this.mAudioManager.dispatchMediaKeyEvent(event);
            event = new KeyEvent(1, 127);
            this.mAudioManager.dispatchMediaKeyEvent(event);
        } else {
            this.mOtherAudioActive = false;
        }
    }

    private void continueExternalAudio() {
        if (this.mOtherAudioActive) {
            LPMobileLog.d(TAG, "continueExternalAudio: Replaying other audi");
            KeyEvent event = new KeyEvent(0, 126);
            this.mAudioManager.dispatchMediaKeyEvent(event);
            event = new KeyEvent(1, 126);
            this.mAudioManager.dispatchMediaKeyEvent(event);
        }
    }

    public boolean isPlaying(String audioFilePath) {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying(audioFilePath);
    }

    public void pause() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.pause();
        }
    }

    public static interface RecordingResultCallback {
        public void onMaxRecordingDurationReached(@Nullable String var1);

        public void onRecordingInterrupted(@Nullable String var1);
    }

    private class LPMediaPlayer
    extends MediaPlayer {
        private final String localFileUrl;
        private final String callbackId;

        public LPMediaPlayer(String callbackId, String localFileUrl) {
            this.callbackId = callbackId;
            this.localFileUrl = localFileUrl;
        }

        public String getCallbackId() {
            return this.callbackId;
        }

        public String getLocalFileUrl() {
            return this.localFileUrl;
        }

        public boolean isPlaying(String audioFileUrl) {
            return this.isPlaying() && !TextUtils.isEmpty((CharSequence)audioFileUrl) && audioFileUrl.equals(this.localFileUrl);
        }

        public boolean isCurrentlyPlaying() {
            return this.isPlaying();
        }
    }

    public static interface PlaybackCallback {
        public void onPlaybackStarted(String var1, int var2);

        public void onPlaybackCompleted(boolean var1, String var2);
    }

    public static enum LPRecorderStatus {
        PermissionDenied,
        Failed,
        Started,
        Finished;

    }
}

