/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.loggos;

import android.net.Uri;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.LPJSONArrayBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/liveperson/infra/loggos/LoggosUploader;", "", "()V", "callback", "Lcom/liveperson/infra/loggos/LoggosUploader$Callback;", "getCallback", "()Lcom/liveperson/infra/loggos/LoggosUploader$Callback;", "setCallback", "(Lcom/liveperson/infra/loggos/LoggosUploader$Callback;)V", "sendBulk", "", "domain", "", "messages", "", "Lorg/json/JSONObject;", "certificates", "Callback", "Companion", "infra_release"})
public class LoggosUploader {
    @Nullable
    private Callback callback;
    private static final String TAG = "LoggosUploader";
    private static final String LOGGOS_URL = "https://%s/api/loggos/log/";
    private static final String APP_NAME = "appName";
    private static final String MESSAGING_SDK = "messaging_SDK_Android";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Callback getCallback() {
        return this.callback;
    }

    public final void setCallback(@Nullable Callback callback) {
        this.callback = callback;
    }

    public void sendBulk(@NotNull String domain, @NotNull List<? extends JSONObject> messages, @NotNull List<String> certificates) {
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
        CharSequence charSequence = domain;
        boolean bl = false;
        if (charSequence.length() == 0 || messages.isEmpty()) {
            LPLog.INSTANCE.w(TAG, "Domain or Message is empty. Did not send log to Loggos.");
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (JSONObject jSONObject : messages) {
            jsonArray.put((Object)jSONObject);
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = LOGGOS_URL;
        Object[] objectArray = new Object[]{domain};
        boolean bl2 = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        Uri uri = Uri.parse((String)string3).buildUpon().appendQueryParameter(APP_NAME, MESSAGING_SDK).build();
        HttpPostRequest postRequest = new HttpPostRequest(uri.toString());
        postRequest.setBody(new LPJSONArrayBody(jsonArray));
        postRequest.setCertificatePinningKeys(certificates);
        postRequest.setCallback(new ICallback<String, Throwable>(this, messages){
            final /* synthetic */ LoggosUploader this$0;
            final /* synthetic */ List $messages;

            public void onSuccess(@Nullable String response) {
                LPLog.INSTANCE.i("LoggosUploader", "Successfully uploaded report to Loggos.");
                if (this.this$0.getCallback() != null) {
                    Callback callback = this.this$0.getCallback();
                    if (callback == null) {
                        Intrinsics.throwNpe();
                    }
                    callback.onSuccess();
                }
            }

            public void onError(@Nullable Throwable exception) {
                LPLog.INSTANCE.w("LoggosUploader", "Error uploading report to Loggos.", exception);
                if (this.this$0.getCallback() != null) {
                    Callback callback = this.this$0.getCallback();
                    if (callback == null) {
                        Intrinsics.throwNpe();
                    }
                    callback.onError(this.$messages, exception);
                }
            }
            {
                this.this$0 = $outer;
                this.$messages = $captured_local_variable$1;
            }
        });
        HttpHandler.execute(postRequest);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&J\b\u0010\t\u001a\u00020\u0003H&\u00a8\u0006\n"}, d2={"Lcom/liveperson/infra/loggos/LoggosUploader$Callback;", "", "onError", "", "messages", "", "Lorg/json/JSONObject;", "exception", "", "onSuccess", "infra_release"})
    public static interface Callback {
        public void onSuccess();

        public void onError(@NotNull List<? extends JSONObject> var1, @Nullable Throwable var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/liveperson/infra/loggos/LoggosUploader$Companion;", "", "()V", "APP_NAME", "", "LOGGOS_URL", "MESSAGING_SDK", "TAG", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

