package com.liveperson.infra.loggos

import com.liveperson.infra.BuildConfig
import com.liveperson.infra.log.LPLog
import com.liveperson.infra.log.LogLine
import org.json.JSONException
import org.json.JSONObject
import java.text.SimpleDateFormat
import java.util.*

class LoggosMessageFactory(private val accountId: String) {

	companion object {
		private const val TAG = "LoggosMessage"

		private const val LOGGOS_CONTEXT = "context"
		private const val LOGGOS_ANDROID_CONTEXT = "AndroidSdk"
		private const val SDK_VERSION = "integrationVersion"
		private const val ACCOUNT_ID = "accountId"

		private const val TIME = "time"
		private const val FILENAME = "filename"
		private const val LOG_LEVEL = "logLevel"
		private const val TITLE = "title"
		private const val MESSAGE = "msg"
		private const val UUID = "uid"


		private const val TIMESTAMP_FORMAT = "yyyy-mm-dd HH:MM:SS,SSS"
	}

	fun convertToJson(logLine: LogLine): JSONObject {
		val jsonObject = JSONObject()
		try {
			jsonObject.put(LOGGOS_CONTEXT, LOGGOS_ANDROID_CONTEXT)
			jsonObject.put(SDK_VERSION, BuildConfig.VERSION_NAME)
			jsonObject.put(ACCOUNT_ID, accountId)

			jsonObject.put(TIME, SimpleDateFormat(TIMESTAMP_FORMAT, Locale.ENGLISH).format(logLine.time))
			jsonObject.put(FILENAME, logLine.tag)
			jsonObject.put(LOG_LEVEL, logLine.level.apiName)
			jsonObject.put(TITLE, logLine.message)
			jsonObject.put(MESSAGE, logLine.toString())
			jsonObject.put(UUID, java.util.UUID.randomUUID().toString())

		} catch (e: JSONException) {
			LPLog.w(TAG, "Exception when serializing Logs to LoggosMessages", e)
		}

		return jsonObject
	}
}
