package com.liveperson.infra.utils;

import com.liveperson.infra.log.LPLog;

import java.lang.Thread.UncaughtExceptionHandler;
import java.util.Arrays;

/**
 * Created by shiranr on 03/04/2016.
 */
public class SDKUncaughtExceptionHandler implements UncaughtExceptionHandler {

    private static final String TAG = "SDKUncaughtExceptionHandler";
    private static final long CRASH_IN_LOOP = 5 * 1000; //5 seconds

    private static SDKUncaughtExceptionHandler instance;

    private final UncaughtExceptionHandler rootHandler; // For storing the host app's Uncaught ExceptionHandler to invoke onto Exceptions we catch.
    private static long lastCrashTime = 0;

    private SDKUncaughtExceptionHandler(UncaughtExceptionHandler exceptionHandler) {
        rootHandler = exceptionHandler;
    }

    // getting the default UCEHandler to store
    public static SDKUncaughtExceptionHandler getInstance(UncaughtExceptionHandler root){
        synchronized (TAG) {
            if (instance == null) {
                instance = new SDKUncaughtExceptionHandler(root);
            }
        }

        return instance;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (isExceptionFromSDK(ex)) {
            // The Exception was thrown from the SDK
            try {
                if (System.currentTimeMillis() - lastCrashTime < CRASH_IN_LOOP) {
                    LPLog.INSTANCE.e(TAG + ": LOOP! " + thread.getName(), "Uncaught Exception!!", ex);
                    return;
                }
                lastCrashTime = System.currentTimeMillis();
	            LPLog.INSTANCE.e(TAG + ": " + thread.getName(), "Uncaught Exception!!", ex);
            } catch (Exception e) {
                LPLog.INSTANCE.e(TAG, "Exception while processing Uncaught Exception!!", e);
            }
        }

        if (rootHandler != null) {
            rootHandler.uncaughtException(thread, ex);
        }
    }

    // checking if the exception was thrown from our sdk. returns True if StackTrace contains sdk's package inside.
    private boolean isExceptionFromSDK(Throwable ex) {
        String check = exceptionStacktraceToString(ex);
        return check.contains("com.liveperson");
    }

    // converting the StackTrace to a string
    private static String exceptionStacktraceToString(Throwable e)
    {
        return Arrays.toString(e.getStackTrace());
    }
}
