/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import com.liveperson.infra.log.LPLog;
import java.util.Arrays;

public class SDKUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = "SDKUncaughtExceptionHandler";
    private static final long CRASH_IN_LOOP = 5000L;
    private static SDKUncaughtExceptionHandler instance;
    private final Thread.UncaughtExceptionHandler rootHandler;
    private static long lastCrashTime;

    private SDKUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.rootHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SDKUncaughtExceptionHandler getInstance(Thread.UncaughtExceptionHandler root) {
        String string2 = TAG;
        synchronized (TAG) {
            if (instance == null) {
                instance = new SDKUncaughtExceptionHandler(root);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (this.isExceptionFromSDK(ex)) {
            try {
                if (System.currentTimeMillis() - lastCrashTime < 5000L) {
                    LPLog.INSTANCE.e("SDKUncaughtExceptionHandler: LOOP! " + thread.getName(), "Uncaught Exception!!", ex);
                    return;
                }
                lastCrashTime = System.currentTimeMillis();
                LPLog.INSTANCE.e("SDKUncaughtExceptionHandler: " + thread.getName(), "Uncaught Exception!!", ex);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, "Exception while processing Uncaught Exception!!", e);
            }
        }
        if (this.rootHandler != null) {
            this.rootHandler.uncaughtException(thread, ex);
        }
    }

    private boolean isExceptionFromSDK(Throwable ex) {
        String check = SDKUncaughtExceptionHandler.exceptionStacktraceToString(ex);
        return check.contains("com.liveperson");
    }

    private static String exceptionStacktraceToString(Throwable e) {
        return Arrays.toString(e.getStackTrace());
    }

    static {
        lastCrashTime = 0L;
    }
}

