package com.liveperson.infra.model;

import java.util.HashMap;
import java.util.List;

/**
 * Created by ofira on 11/26/17.
 */

public class SocketConnectionParams {

    private String mUrl;
    private int mTimeout;
    private List<String> mCertificates;
    private HashMap<String, String> headers = new HashMap<>();

    public SocketConnectionParams(String url, int timeout) {
        this(url, timeout, null);
    }

    public SocketConnectionParams(String url, int timeout, List<String> certificates) {
        mUrl = url;
        mTimeout = timeout;
        mCertificates = certificates;
    }

    public String getUrl() {
        return mUrl;
    }

    public int getTimeout() {
        return mTimeout;
    }

    public List<String> getCertificatePinningKeys() {
        return mCertificates;
    }

    public HashMap<String, String> getHeaders() {
        return headers;
    }

    public void addHeader(String key, String value) {
        headers.put(key, value);
    }
}
