/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import android.content.res.Resources;
import android.security.KeyPairGeneratorSpec;
import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.infra.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Calendar;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;
import kotlin.text.Charsets;

public class DBEncryptionKeyHelper
implements Clearable {
    private static final String TAG = "DBEncryptionKeyHelper";
    private static final String DB_ENCRYPTION_KEY = "dbEncryptionKey";
    private static final String DB_ENCRYPTION_USES_KEYSTORE = "dbEncryptionUsesKeyStore";
    private static final String ANDROID_INFRA_DB_ENC_KEY = "androidInfraDbEncKey";
    private static final String DB_ENC_CN = "CN=DBKeyEncryptor, O=Liveperson";
    private static final String TRANSFORMATION_RSA = "RSA/ECB/PKCS1Padding";
    private static final String TRANSFORMATION_AES = "AES/CBC/PKCS5Padding";
    private static final String INITIALIZATION_VECTOR = "initializationVector";
    private SecretKey dbEncryptionKey;
    private KeyStore androidKeyStore = null;
    private SecureRandom secureRandom = new SecureRandom();
    private IvParameterSpec ivSpec;

    public DBEncryptionKeyHelper(String externalEncryptionKey) {
        String encryptionKey;
        byte[] iv;
        String initializationVectorFromSharedPrefs = PreferenceManager.getInstance().getStringValue(INITIALIZATION_VECTOR, "appLevelPreferences", null);
        if (initializationVectorFromSharedPrefs == null) {
            iv = new byte[16];
            this.secureRandom.nextBytes(iv);
            PreferenceManager.getInstance().setStringValue(INITIALIZATION_VECTOR, "appLevelPreferences", Base64.encodeToString((byte[])iv, (int)0));
        } else {
            iv = Base64.decode((String)initializationVectorFromSharedPrefs, (int)0);
        }
        this.ivSpec = new IvParameterSpec(iv);
        try {
            this.androidKeyStore = KeyStore.getInstance("AndroidKeyStore");
            this.androidKeyStore.load(null, null);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Failed to load Keystore.", e);
        }
        if (externalEncryptionKey == null) {
            KeyStore.PrivateKeyEntry privateKeyEntryForValidation;
            String encryptedEncryptionKeyFromSharedPrefs = PreferenceManager.getInstance().getStringValue(DB_ENCRYPTION_KEY, "appLevelPreferences", null);
            try {
                privateKeyEntryForValidation = (KeyStore.PrivateKeyEntry)this.androidKeyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            }
            catch (Exception e) {
                privateKeyEntryForValidation = null;
            }
            if (encryptedEncryptionKeyFromSharedPrefs == null || privateKeyEntryForValidation == null) {
                encryptionKey = this.generateAesEncryptionKey();
                this.encryptAndSaveKey(encryptionKey);
            } else {
                boolean isKeyEncryptedUsingKeyStore = PreferenceManager.getInstance().getBooleanValue(DB_ENCRYPTION_USES_KEYSTORE, "appLevelPreferences", false);
                if (isKeyEncryptedUsingKeyStore) {
                    encryptionKey = this.decryptKey(encryptedEncryptionKeyFromSharedPrefs);
                } else {
                    encryptionKey = encryptedEncryptionKeyFromSharedPrefs;
                    this.encryptAndSaveKey(encryptionKey);
                }
            }
        } else {
            encryptionKey = externalEncryptionKey;
        }
        this.setDbEncryptionKey(encryptionKey);
    }

    private String decryptKey(String encryptedKey) {
        String decryptedKey = null;
        try {
            int nextByte;
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)this.androidKeyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            Cipher output = Cipher.getInstance(TRANSFORMATION_RSA);
            output.init(2, privateKeyEntry.getPrivateKey());
            CipherInputStream cipherInputStream = new CipherInputStream(new ByteArrayInputStream(Base64.decode((String)encryptedKey, (int)0)), output);
            ArrayList<Byte> values = new ArrayList<Byte>();
            while ((nextByte = cipherInputStream.read()) != -1) {
                values.add((byte)nextByte);
            }
            byte[] bytes = new byte[values.size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (Byte)values.get(i);
            }
            decryptedKey = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Exception while decrypting key.", e);
        }
        return decryptedKey;
    }

    private void encryptAndSaveKey(String decryptedKey) {
        String encryptedKey;
        boolean usesAndroidKeyStore = true;
        this.generateKeyPairInStoreIfNotExists(ANDROID_INFRA_DB_ENC_KEY);
        try {
            KeyStore.PrivateKeyEntry publicKeyEntry = (KeyStore.PrivateKeyEntry)this.androidKeyStore.getEntry(ANDROID_INFRA_DB_ENC_KEY, null);
            Cipher input = Cipher.getInstance(TRANSFORMATION_RSA);
            input.init(1, publicKeyEntry.getCertificate().getPublicKey());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, input);
            cipherOutputStream.write(decryptedKey.getBytes(StandardCharsets.UTF_8));
            cipherOutputStream.close();
            byte[] keyByteArray = outputStream.toByteArray();
            encryptedKey = Base64.encodeToString((byte[])keyByteArray, (int)0);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Exception while encrypting/saving key.", e);
            encryptedKey = decryptedKey;
            usesAndroidKeyStore = false;
        }
        PreferenceManager.getInstance().setStringValue(DB_ENCRYPTION_KEY, "appLevelPreferences", encryptedKey);
        PreferenceManager.getInstance().setBooleanValue(DB_ENCRYPTION_USES_KEYSTORE, "appLevelPreferences", usesAndroidKeyStore);
    }

    private String generateAesEncryptionKey() {
        SecretKey secretKey;
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256);
            secretKey = keyGen.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LPLog.INSTANCE.e(TAG, "Exception while generating AES Encryption Key", e);
            byte[] randomBytes = new byte[32];
            this.secureRandom.nextBytes(randomBytes);
            return Base64.encodeToString((byte[])randomBytes, (int)0);
        }
        return Base64.encodeToString((byte[])secretKey.getEncoded(), (int)0);
    }

    private void generateKeyPairInStoreIfNotExists(String alias) {
        try {
            if (!this.androidKeyStore.containsAlias(alias)) {
                Calendar start = Calendar.getInstance();
                Calendar end = Calendar.getInstance();
                end.add(1, 120);
                KeyPairGeneratorSpec spec = new KeyPairGeneratorSpec.Builder(Infra.instance.getApplicationContext()).setAlias(alias).setSubject(new X500Principal(DB_ENC_CN)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
                KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                generator.initialize((AlgorithmParameterSpec)spec);
                generator.generateKeyPair();
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, "Exception while generating KeyPair.", e);
        }
    }

    private void setDbEncryptionKey(String key) {
        byte[] decodedKey = Base64.decode((String)key, (int)0);
        decodedKey[0] = (byte)(decodedKey[0] + 1);
        this.dbEncryptionKey = new SecretKeySpec(decodedKey, "AES");
    }

    private SecretKey getDbEncryptionKey() {
        return this.dbEncryptionKey;
    }

    String encrypt(String plainText) {
        if (!TextUtils.isEmpty((CharSequence)plainText)) {
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION_AES);
                cipher.init(1, (Key)this.getDbEncryptionKey(), this.ivSpec);
                byte[] encryptedBytes = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));
                return Base64.encodeToString((byte[])encryptedBytes, (int)0);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, "Exception while encrypting text.", e);
            }
        }
        return plainText;
    }

    String decrypt(String cipherText) {
        String plainText = "";
        if (!TextUtils.isEmpty((CharSequence)cipherText)) {
            try {
                Cipher cipher = Cipher.getInstance(TRANSFORMATION_AES);
                cipher.init(2, (Key)this.getDbEncryptionKey(), this.ivSpec);
                byte[] data = Base64.decode((String)cipherText, (int)0);
                byte[] decryptedBytes = cipher.doFinal(data);
                plainText = new String(decryptedBytes, Charsets.UTF_8);
            }
            catch (BadPaddingException badPaddingException) {
                LPLog.INSTANCE.w(TAG, FlowTags.DECRYPTION, "Caught a bad padding exception!", badPaddingException);
                LPLog.INSTANCE.d(TAG, FlowTags.DECRYPTION, "Using fallback after BadPaddingException");
                try {
                    Cipher cipher = Cipher.getInstance(TRANSFORMATION_AES);
                    cipher.init(2, (Key)this.getDbEncryptionKey(), this.ivSpec);
                    byte[] data = Utils.hexStringToByteArray(cipherText);
                    byte[] decryptedBytes = cipher.doFinal(data);
                    plainText = new String(decryptedBytes, Charsets.UTF_8);
                    LPLog.INSTANCE.d(TAG, FlowTags.DECRYPTION, "BadPaddingException fallback worked!");
                }
                catch (Exception e) {
                    LPLog.INSTANCE.e(TAG, FlowTags.DECRYPTION, "BadPaddingException fallback failed.", e);
                }
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, FlowTags.DECRYPTION, "Caught an unexpected exception.", e);
            }
        }
        return plainText;
    }

    public static EncryptionVersion getAppEncryptionVersion() {
        try {
            int encryptionVersion = Configuration.getInteger(R.integer.encryptionVersion);
            return EncryptionVersion.fromInt(encryptionVersion);
        }
        catch (Resources.NotFoundException e) {
            LPLog.INSTANCE.e(TAG, "Exception while getting app encryption version.", e);
            return EncryptionVersion.VERSION_1;
        }
    }

    @Override
    public void clear() {
        if (this.androidKeyStore != null) {
            try {
                this.androidKeyStore.deleteEntry(ANDROID_INFRA_DB_ENC_KEY);
            }
            catch (Exception kse) {
                LPLog.INSTANCE.d(TAG, "exception deleting key store entry: ", kse);
            }
        }
    }
}

