/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log;

import com.liveperson.infra.log.LogLevel;
import com.liveperson.infra.log.LogLine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/liveperson/infra/log/LoggingQueue;", "", "maxSize", "", "(I)V", "backingQueue", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/liveperson/infra/log/LogLine;", "size", "getSize", "()I", "add", "", "line", "clear", "", "getLogSnapshot", "", "filter", "Lcom/liveperson/infra/log/LogLevel;", "getLogSnapshotStringBlock", "", "getLogSnapshotStrings", "isEmpty", "infra_release"})
public final class LoggingQueue {
    private final LinkedBlockingQueue<LogLine> backingQueue;

    public final int getSize() {
        return this.backingQueue.size();
    }

    public final boolean isEmpty() {
        return this.backingQueue.isEmpty();
    }

    public final boolean add(@NotNull LogLine line) {
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        while (!this.backingQueue.offer(line)) {
            this.backingQueue.remove();
        }
        return true;
    }

    public final void clear() {
        this.backingQueue.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LogLine> getLogSnapshot(@NotNull LogLevel filter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Iterable $this$filter$iv = this.backingQueue;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LogLine line = (LogLine)element$iv$iv;
            boolean bl = false;
            if (!(line.getLevel().compareTo((Enum)filter) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getLogSnapshotStrings(@NotNull LogLevel filter) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        Iterable $this$map$iv = this.getLogSnapshot(filter);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line;
            LogLine logLine = (LogLine)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = line.toString();
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getLogSnapshotStringBlock(@NotNull LogLevel filter) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)filter), (String)"filter");
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String lineString : this.getLogSnapshotStrings(filter)) {
            if (first) {
                first = false;
            } else {
                builder.append("\n");
            }
            builder.append(lineString);
        }
        String string2 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"builder.toString()");
        return string2;
    }

    public LoggingQueue(int maxSize) {
        this.backingQueue = new LinkedBlockingQueue(maxSize);
    }
}

