package com.liveperson.infra.network.socket;


/**
 * Created by ofira on 11/23/17.
 */

public enum SocketState {

    /**
     * Initial state of the webSocket
     */
    INIT,

    /**
     * An opening handshake is being performed.
     */
    CONNECTING,

    /**
     * The WebSocket connection is established (opening handshake has succeeded) and usable.
     */
    OPEN,

    /**
     * A closing handshake is being performed.
     */
    CLOSING,


    /**
     * The WebSocket connection is closed.
     */
    CLOSED,


    /**
     * The webSocket has been closed due to an error reading from or writing to the network.
     */
    ERROR
}
