package com.liveperson.infra.utils

import android.text.TextUtils
import android.util.Base64
import com.liveperson.infra.errors.ErrorCode
import com.liveperson.infra.errors.ErrorCode.*
import com.liveperson.infra.log.FlowTags
import com.liveperson.infra.log.LPLog.d
import com.liveperson.infra.log.LPLog.e
import com.liveperson.infra.log.LPLog.mask
import org.json.JSONObject
import java.nio.charset.StandardCharsets

/**
 * Note: This class is copied from TokenUtils from messaging module. Once we have new auth changes implemented,
 * remove TokenUtils from messaging and copy remaining functions here.
 */
object TokenUtils {

    private val TAG = "TokenUtils"
    fun getConsumerUserId(jwt: String?): String? {
        if (TextUtils.isEmpty(jwt)) {
            return ""
        } else {
            d(TAG, FlowTags.LOGIN, "getConsumerUserId: Getting original consumerId from jwt: " + mask(jwt))
            val segments = jwt?.split(".")?.toTypedArray()
            if (segments?.size!! < 3) {
                return ""
            }

            //example:
            // 			{
            //				****"sub": "b555ec39a12c560c2c76b43f5e218ccbd46c981318bd0df1c94db72aa48b9d95",*****
            //					"aud": "acc:le22225965",
            //					....
            //					"exp": 1524988657,
            //					"iat": 1524988057
            //			}
            //take the second segment, decode it (base64), convert it to json object, and find "lp.ext"."sub" value.
            try {
                val secondSegmentsByte = Base64.decode(segments[1], Base64.DEFAULT)
                val secondSegments = String(secondSegmentsByte, StandardCharsets.UTF_8)
                val secondSegmentsJson = JSONObject(secondSegments)
                return secondSegmentsJson.optString("sub")
            } catch (e: Exception) {
                e(TAG, ERR_00000141, "getConsumerUserId: Exception while getting Consumer User ID.", e)
            }
            return ""
        }
    }
}