/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/infra/utils/TokenUtils;", "", "()V", "TAG", "", "getConsumerUserId", "jwt", "infra_release"})
public final class TokenUtils {
    private static final String TAG = "TokenUtils";
    public static final TokenUtils INSTANCE;

    @Nullable
    public final String getConsumerUserId(@Nullable String jwt) {
        String[] stringArray;
        Object thisCollection$iv;
        if (TextUtils.isEmpty((CharSequence)jwt)) {
            return "";
        }
        LPLog.INSTANCE.d(TAG, FlowTags.LOGIN, "getConsumerUserId: Getting original consumerId from jwt: " + LPLog.INSTANCE.mask(jwt));
        Object object = jwt;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null)) != null) {
            Collection $this$toTypedArray$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray2;
        } else {
            stringArray = null;
        }
        String[] segments = stringArray;
        Integer n = segments != null ? Integer.valueOf(segments.length) : null;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        if (n < 3) {
            return "";
        }
        try {
            byte[] secondSegmentsByte = Base64.decode((String)segments[1], (int)0);
            Intrinsics.checkExpressionValueIsNotNull((Object)secondSegmentsByte, (String)"secondSegmentsByte");
            thisCollection$iv = secondSegmentsByte;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            String secondSegments = new String((byte[])thisCollection$iv, charset2);
            JSONObject secondSegmentsJson = new JSONObject(secondSegments);
            return secondSegmentsJson.optString("sub");
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000141, "getConsumerUserId: Exception while getting Consumer User ID.", e);
            return "";
        }
    }

    private TokenUtils() {
    }

    static {
        TokenUtils tokenUtils;
        INSTANCE = tokenUtils = new TokenUtils();
        TAG = TAG;
    }
}

