/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.controller.PlayingAudioManager;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.DetectHeadsetUnpluggedBroadcastReceiver;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.UniqueID;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class LPAudioUtils {
    private static final String TAG = "LPAudioUtils";
    private final File mFilesFolder;
    public static String VOICE_FOLDER = "voice/";
    private static final String AUDIO_RECORDING_STARTED_BROADCAST = "AUDIO_RECORDING_STARTED_BROADCAST";
    private static final String AUDIO_RECORDING_STOPPED_BROADCAST = "AUDIO_RECORDING_STOPPED_BROADCAST";
    private final HashMap<String, PlaybackCallback> mCallbacks;
    @Nullable
    private LPMediaPlayer mMediaPlayer;
    @Nullable
    private MediaRecorder mMediaRecorder;
    private File mTempRecordedAudioFile;
    private RecordingResultCallback recordingCallback;
    private PlayingAudioManager mPlayingAudioManager;
    private AudioManager mAudioManager;
    private boolean mOtherAudioActive = false;
    private DetectHeadsetUnpluggedBroadcastReceiver mDetectHeadsetUnpluggedBroadcastReceiver = new DetectHeadsetUnpluggedBroadcastReceiver(){

        @Override
        protected void onUnpluggedHeadset() {
            LPAudioUtils.this.mPlayingAudioManager.stopAllCurrentlyPlaying();
            LPAudioUtils.this.stopPlayback();
        }
    };

    public LPAudioUtils() {
        this.mCallbacks = new HashMap();
        this.mFilesFolder = Infra.instance.getApplicationContext().getFilesDir();
        this.mPlayingAudioManager = new PlayingAudioManager();
        this.mAudioManager = (AudioManager)Infra.instance.getApplicationContext().getSystemService("audio");
    }

    private MediaRecorder initMediaRecorder() {
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.release();
        }
        MediaRecorder mediaRecorder = new MediaRecorder();
        mediaRecorder.setAudioChannels(1);
        mediaRecorder.setAudioSource(1);
        mediaRecorder.setOutputFormat(2);
        mediaRecorder.setAudioEncoder(3);
        mediaRecorder.setAudioSamplingRate(16000);
        return mediaRecorder;
    }

    private LPMediaPlayer initMediaPlayer(String callbackId, String localFile, MediaPlayer.OnCompletionListener onCompletionListener) {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.release();
        }
        LPMediaPlayer mediaPlayer = new LPMediaPlayer(callbackId, localFile);
        mediaPlayer.setOnCompletionListener(onCompletionListener);
        return mediaPlayer;
    }

    public void startRecording(String filename, int maxDurationMs, RecordingResultCallback recordingResultCallback) {
        LPLog.INSTANCE.d(TAG, "startRecording: start recording with max duration (ms) : " + maxDurationMs);
        this.mTempRecordedAudioFile = new File(this.getVoiceFolder(), filename);
        this.recordingCallback = recordingResultCallback;
        this.mMediaRecorder = this.initMediaRecorder();
        boolean didStartRecording = false;
        this.mMediaRecorder.setOutputFile(this.mTempRecordedAudioFile.getPath());
        this.mMediaRecorder.setMaxDuration(maxDurationMs);
        this.mMediaRecorder.setOnInfoListener((mediaRecorder, what, extra) -> {
            if (what == 800) {
                LPLog.INSTANCE.d(TAG, "onInfo: maximum recoding time reached. Stop the recording and call the callback");
                this.stopRecording(new ICallback<String, Exception>(){

                    @Override
                    public void onSuccess(String audioFilePath) {
                        if (LPAudioUtils.this.recordingCallback != null) {
                            LPAudioUtils.this.recordingCallback.onMaxRecordingDurationReached(audioFilePath);
                            LPAudioUtils.this.recordingCallback = null;
                        }
                    }

                    @Override
                    public void onError(Exception exception) {
                        if (LPAudioUtils.this.recordingCallback != null) {
                            LPAudioUtils.this.recordingCallback.onMaxRecordingDurationReached(null);
                            LPAudioUtils.this.recordingCallback = null;
                        }
                    }
                });
            }
        });
        try {
            this.pauseExternalAudio();
            this.mMediaRecorder.prepare();
            this.mMediaRecorder.start();
            didStartRecording = true;
        }
        catch (Throwable exception) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000025, "failed to start audio record", exception);
        }
        if (didStartRecording) {
            LocalBroadcast.sendBroadcast(AUDIO_RECORDING_STARTED_BROADCAST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording(ICallback<String, Exception> resultCallback) {
        LPLog.INSTANCE.d(TAG, "stopRecording: stop recording");
        if (!this.isRecording()) {
            if (resultCallback != null) {
                resultCallback.onError(new Exception("missing recorded file"));
            }
            return;
        }
        String tempAudioFilePath = this.mTempRecordedAudioFile.getPath();
        LPLog.INSTANCE.d(TAG, "stopRecording: recording file path: " + tempAudioFilePath);
        try {
            this.mMediaRecorder.stop();
            this.mMediaRecorder.release();
            this.continueExternalAudio();
            if (resultCallback != null) {
                resultCallback.onSuccess(tempAudioFilePath);
            }
            if (this.recordingCallback != null) {
                this.recordingCallback.onRecordingInterrupted(tempAudioFilePath);
            }
            LocalBroadcast.sendBroadcast(AUDIO_RECORDING_STOPPED_BROADCAST);
        }
        catch (IllegalStateException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000026, "failed to stop audio record", e);
        }
        finally {
            this.mMediaRecorder = null;
            this.mTempRecordedAudioFile = null;
            this.recordingCallback = null;
        }
    }

    public static void getDuration(String filePath, ICallback<Integer, Exception> resultCallback) {
        if (resultCallback == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            resultCallback.onError(new Exception("file path is empty"));
            return;
        }
        MediaPlayer mediaPlayer = new MediaPlayer();
        try {
            mediaPlayer.setDataSource(filePath);
            mediaPlayer.setOnPreparedListener(mp -> resultCallback.onSuccess(mp.getDuration()));
            mediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            LPLog.INSTANCE.w(TAG, "getDuration: error getting duration of file " + filePath, e);
            resultCallback.onError(e);
        }
    }

    public void bindPlayingAudio(String callbackId, PlaybackCallback playbackCallback) {
        this.mCallbacks.put(callbackId, playbackCallback);
    }

    public void playAudio(String audioFileUrl, String callbackId, PlaybackCallback playbackCallback) {
        if (playbackCallback == null) {
            return;
        }
        if (this.mMediaPlayer != null) {
            PlaybackCallback callback;
            if (this.mMediaPlayer.isPlaying(audioFileUrl)) {
                return;
            }
            if (this.mMediaPlayer.getLocalFileUrl().equals(audioFileUrl)) {
                this.pauseExternalAudio();
                this.mMediaPlayer.start();
                playbackCallback.onPlaybackStarted(audioFileUrl, this.mMediaPlayer.getDuration());
                return;
            }
            if (!this.mMediaPlayer.getLocalFileUrl().equals(audioFileUrl) && this.mCallbacks.containsKey(this.mMediaPlayer.callbackId) && (callback = this.mCallbacks.remove(this.mMediaPlayer.callbackId)) != null) {
                callback.onPlaybackCompleted(false, this.mMediaPlayer.getLocalFileUrl());
            }
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        if (this.isRecording()) {
            this.stopRecording(null);
        }
        if (TextUtils.isEmpty((CharSequence)audioFileUrl)) {
            playbackCallback.onPlaybackCompleted(false, audioFileUrl);
            return;
        }
        File tempPlayedAudioFile = new File(audioFileUrl);
        if (tempPlayedAudioFile.exists()) {
            this.mCallbacks.put(callbackId, playbackCallback);
            this.mMediaPlayer = this.initMediaPlayer(callbackId, audioFileUrl, mp -> {
                if (!(mp instanceof LPMediaPlayer)) {
                    return;
                }
                LPMediaPlayer mediaPlayer = (LPMediaPlayer)mp;
                PlaybackCallback callback = this.mCallbacks.remove(mediaPlayer.getCallbackId());
                String _audioFileUrl = audioFileUrl;
                if (mediaPlayer == this.mMediaPlayer) {
                    this.cleanupPlayback();
                    _audioFileUrl = mediaPlayer.getLocalFileUrl();
                    LPLog.INSTANCE.d(TAG, "Playback completed: " + _audioFileUrl);
                }
                if (callback != null) {
                    callback.onPlaybackCompleted(true, _audioFileUrl);
                }
            });
            try {
                this.mMediaPlayer.setDataSource(audioFileUrl);
                this.mMediaPlayer.setOnPreparedListener(mp -> {
                    if (this.mMediaPlayer == mp) {
                        this.pauseExternalAudio();
                        mp.start();
                        LPLog.INSTANCE.d(TAG, "onPrepared: Registering to detect unplugged headset");
                        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
                        Infra.instance.getApplicationContext().registerReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver, intentFilter);
                        PlaybackCallback callback = this.mCallbacks.get(this.mMediaPlayer.getCallbackId());
                        if (callback != null) {
                            callback.onPlaybackStarted(audioFileUrl, mp.getDuration());
                        }
                    }
                });
                this.mMediaPlayer.prepareAsync();
            }
            catch (IOException e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000027, "Exception while opening data source with media player.", e);
            }
        }
    }

    @Nullable
    private String getVoiceFolder() {
        File outgoingAudioFolder = new File(this.mFilesFolder + "/" + VOICE_FOLDER);
        if (!outgoingAudioFolder.exists() && !outgoingAudioFolder.mkdirs()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000028, "getVoiceFolder: Audio folder could not be created");
            return null;
        }
        return outgoingAudioFolder.getPath();
    }

    private void cleanupPlayback() {
        LPMediaPlayer mp = this.mMediaPlayer;
        this.mMediaPlayer = null;
        if (mp != null) {
            mp.stop();
            mp.release();
            this.continueExternalAudio();
            try {
                Infra.instance.getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                LPLog.INSTANCE.w(TAG, "cleanupPlayback: receiver is not registered", e);
            }
            this.mCallbacks.remove(mp.getCallbackId());
        }
    }

    private boolean isRecording() {
        return this.mTempRecordedAudioFile != null && this.mMediaRecorder != null;
    }

    public int getCurrentPlayingLocation() {
        int location = 0;
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            location = this.mMediaPlayer.getCurrentPosition();
        }
        return location;
    }

    public int getCurrentPlayingDuration() {
        int duration = -1;
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            duration = this.mMediaPlayer.getDuration();
        }
        return duration;
    }

    public void stopPlayback() {
        if (this.mMediaPlayer != null) {
            PlaybackCallback callback;
            if (this.mMediaPlayer.isCurrentlyPlaying() && this.mMediaPlayer.getLocalFileUrl() != null && this.mMediaPlayer.callbackId != null && this.mCallbacks.containsKey(this.mMediaPlayer.callbackId) && (callback = this.mCallbacks.remove(this.mMediaPlayer.callbackId)) != null) {
                callback.onPlaybackCompleted(false, this.mMediaPlayer.getLocalFileUrl());
            }
            this.cleanupPlayback();
        }
    }

    public PlayingAudioManager getPlayingAudioManager() {
        return this.mPlayingAudioManager;
    }

    public String saveByteArrayToDisk(byte[] fileByteArray) {
        File filePath = new File(this.getVoiceFolder(), LPAudioUtils.generateVoiceFileName());
        LPLog.INSTANCE.d(TAG, "saveByteArrayToDisk: filePath: " + filePath.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            fos.write(fileByteArray);
        }
        catch (FileNotFoundException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000029, "saveByteArrayToDisk: File not found", e);
            return null;
        }
        catch (IOException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000002A, "saveByteArrayToDisk: IOException", e);
        }
        LPLog.INSTANCE.d(TAG, "saveByteArrayToDisk: file absolute path: " + filePath.getAbsolutePath());
        return filePath.getAbsolutePath();
    }

    public static String generateVoiceFileName() {
        return UniqueID.createUniqueMessageEventId() + ".m4a";
    }

    private void pauseExternalAudio() {
        if (this.mAudioManager.isMusicActive()) {
            this.mOtherAudioActive = true;
            LPLog.INSTANCE.d(TAG, "pauseExternalAudio: other audio is playing. Pausing it...");
            KeyEvent event = new KeyEvent(0, 127);
            this.mAudioManager.dispatchMediaKeyEvent(event);
            event = new KeyEvent(1, 127);
            this.mAudioManager.dispatchMediaKeyEvent(event);
        } else {
            this.mOtherAudioActive = false;
        }
    }

    private void continueExternalAudio() {
        if (this.mOtherAudioActive) {
            LPLog.INSTANCE.d(TAG, "continueExternalAudio: Replaying other audi");
            KeyEvent event = new KeyEvent(0, 126);
            this.mAudioManager.dispatchMediaKeyEvent(event);
            event = new KeyEvent(1, 126);
            this.mAudioManager.dispatchMediaKeyEvent(event);
        }
    }

    public boolean isPlaying(String audioFilePath) {
        return this.mMediaPlayer != null && this.mMediaPlayer.isPlaying(audioFilePath);
    }

    public static interface RecordingResultCallback {
        public void onMaxRecordingDurationReached(@Nullable String var1);

        public void onRecordingInterrupted(@Nullable String var1);
    }

    private class LPMediaPlayer
    extends MediaPlayer {
        private final String localFileUrl;
        private final String callbackId;

        LPMediaPlayer(String callbackId, String localFileUrl) {
            this.callbackId = callbackId;
            this.localFileUrl = localFileUrl;
        }

        String getCallbackId() {
            return this.callbackId;
        }

        String getLocalFileUrl() {
            return this.localFileUrl;
        }

        boolean isPlaying(String audioFileUrl) {
            return this.isPlaying() && !TextUtils.isEmpty((CharSequence)audioFileUrl) && audioFileUrl.equals(this.localFileUrl);
        }

        boolean isCurrentlyPlaying() {
            return this.isPlaying();
        }
    }

    public static interface PlaybackCallback {
        public void onPlaybackStarted(String var1, int var2);

        public void onPlaybackCompleted(boolean var1, String var2);
    }
}

