/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.picasso;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.Uri;
import com.liveperson.infra.utils.picasso.Picasso;
import com.liveperson.infra.utils.picasso.Request;
import com.liveperson.infra.utils.picasso.RequestHandler;
import java.io.IOException;
import java.io.InputStream;
import okio.Okio;
import okio.Source;

class AssetRequestHandler
extends RequestHandler {
    protected static final String ANDROID_ASSET = "android_asset";
    private static final int ASSET_PREFIX_LENGTH = "file:///android_asset/".length();
    private final Context context;
    private final Object lock = new Object();
    private AssetManager assetManager;

    AssetRequestHandler(Context context) {
        this.context = context;
    }

    @Override
    public boolean canHandleRequest(Request data) {
        Uri uri = data.uri;
        return "file".equals(uri.getScheme()) && !uri.getPathSegments().isEmpty() && ANDROID_ASSET.equals(uri.getPathSegments().get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        if (this.assetManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.assetManager == null) {
                    this.assetManager = this.context.getAssets();
                }
            }
        }
        Source source = Okio.source((InputStream)this.assetManager.open(AssetRequestHandler.getFilePath(request)));
        return new RequestHandler.Result(source, Picasso.LoadedFrom.DISK);
    }

    static String getFilePath(Request request) {
        return request.uri.toString().substring(ASSET_PREFIX_LENGTH);
    }
}

