/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils.picasso;

import android.content.Context;
import android.media.ExifInterface;
import android.net.Uri;
import com.liveperson.infra.utils.picasso.ContentStreamRequestHandler;
import com.liveperson.infra.utils.picasso.Picasso;
import com.liveperson.infra.utils.picasso.Request;
import com.liveperson.infra.utils.picasso.RequestHandler;
import java.io.IOException;
import java.io.InputStream;
import okio.Okio;
import okio.Source;

class FileRequestHandler
extends ContentStreamRequestHandler {
    FileRequestHandler(Context context) {
        super(context);
    }

    @Override
    public boolean canHandleRequest(Request data) {
        return "file".equals(data.uri.getScheme());
    }

    @Override
    public RequestHandler.Result load(Request request, int networkPolicy) throws IOException {
        Source source = Okio.source((InputStream)this.getInputStream(request));
        return new RequestHandler.Result(null, source, Picasso.LoadedFrom.DISK, FileRequestHandler.getFileExifRotation(request.uri));
    }

    static int getFileExifRotation(Uri uri) throws IOException {
        ExifInterface exifInterface = new ExifInterface(uri.getPath());
        return exifInterface.getAttributeInt("Orientation", 1);
    }
}

