package com.liveperson.infra.controller;

import com.liveperson.infra.Infra;
import com.liveperson.infra.utils.EncryptionVersion;

/**
 * Class that handles the encryption/decryption of data based on the
 * encryption version that was used
 * Created by ofira on 7/25/16.
 */
public class DBEncryptionHelper {

    public static String encrypt(EncryptionVersion encVersion, String plainText){

        if (encVersion == EncryptionVersion.VERSION_1) {
            plainText = Infra.instance.getDBEncryptionService().encrypt(plainText);
        }
        return plainText;
    }

    public static String decrypt(EncryptionVersion encVersion, String cipherText){

        if (encVersion == EncryptionVersion.VERSION_1) {
            cipherText = Infra.instance.getDBEncryptionService().decrypt(cipherText);
        }
        return cipherText;
    }
}
