package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

import com.liveperson.infra.log.LPLog;

/**
 * Created by ofira on 24/07/2015.
 */
public class DialogsTable implements BaseTable {

    private static final String TAG = "DialogsTable";

    //Conversation table name
    public static final String TABLE_NAME = "dialogs";

    public class Key {
        public static final String CONVERSATION_ID = "conversation_id";
        public static final String DIALOG_ID = "dialog_id";
        public static final String DIALOG_TYPE = "dialog_type";
        public static final String CHANNEL_TYPE = "channel_type";
        public static final String BRAND_ID = "brand_id";
        public static final String TARGET_ID = "target_id";
        public static final String UNREAD_MESSAGES_COUNT = "unread_msg_count";

        public static final String CLOSE_REASON = "close_reason";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String END_TIMESTAMP = "end_timestamp";
        public static final String CSAT_STATUS = "csat_status";
        public static final String TTR_TYPE = "ttr_type";
        public static final String ASSIGNED_AGENT_ID = "assigned_agent_id";
        public static final String LAST_SERVER_SEQUENCE = "last_server_sequence";
        public static final String REQUEST_ID = "request_id";
        public static final String STATE = "state";
        public static final String CONCURRENT_REQUESTS_COUNTER = "concurrent_requests_counter";
    }

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public String getCreateCommand() {
        //TODO: Check what are the changes from the DB Version 1
        return "create table " + TABLE_NAME + "(" +
                KEY_ID + " integer primary key autoincrement," +
                Key.DIALOG_ID + " text unique," +
                Key.CONVERSATION_ID + " text," +
                Key.DIALOG_TYPE + " text," +
                Key.CHANNEL_TYPE + " text," +
                Key.BRAND_ID + " text," +
                Key.TARGET_ID + " text," +
                Key.ASSIGNED_AGENT_ID + " text," +
                Key.UNREAD_MESSAGES_COUNT + " integer default -1," +
                Key.START_TIMESTAMP + " big int not null," +
                Key.REQUEST_ID + " big int," +
                Key.TTR_TYPE + " integer," +
                Key.LAST_SERVER_SEQUENCE + " integer default -1," +
                Key.CSAT_STATUS + " long default -1," +
                Key.END_TIMESTAMP + " long default -1," +
                Key.CLOSE_REASON + " integer default -1," +
                Key.CONCURRENT_REQUESTS_COUNTER + " integer default 0," +
                Key.STATE + " integer," +
                " UNIQUE ( " + Key.DIALOG_ID + ") ON CONFLICT IGNORE" +
                ");";
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (newVersion == 6) {
            // Do nothing...
            LPLog.INSTANCE.i(TAG, "It's the version of this table's arrival");
        }
    }
}
