package com.liveperson.infra.statemachine;


import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.statemachine.interfaces.IEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.infra.statemachine.interfaces.IStateMachineExecutor;

/**
 * Created by shiranr on 13/03/2016.
 */
public abstract class BaseStateMachine implements IStateMachine<IState>, ShutDown {
    private final String logTag;
    private IState activeState;
    private IStateMachineExecutor mStateMachineExecutor;

    protected BaseStateMachine(String tag){
        logTag = tag;
    }

    @Override
    public String getTag() {
        return logTag;
    }

    @Override
    public void initActiveState(IState state) {
        this.activeState = state;
    }

    @Override
    public IState activeState() {
        return this.activeState;
    }
    @Override
    public void setStateMachineExecutor(IStateMachineExecutor stateMachineExecutor) {
        mStateMachineExecutor = stateMachineExecutor;
    }
    @Override
    public void postEvent(final IEvent event) {
        mStateMachineExecutor.post(event);
    }

    @Override
    public Runnable postDelayEvent(final IEvent event, long delay) {
        return mStateMachineExecutor.schedule(event, delay);
    }
    public void changeStateAndPassEvent(IState nextState, IEvent ev) {
        changeState(nextState);
        apply(ev);
    }

    public void cancelDelayedEvent(Runnable delayedTask) {
        mStateMachineExecutor.cancel(delayedTask);
    }

    @Override
    public void apply(IEvent event) {
        LPLog.INSTANCE.d(logTag, activeState().toString() + " <-<- " + event.toString());
        event.accept(activeState());
    }

    @Override
    public void changeState(IState nextState) {
        this.activeState.actionOnExit();
        LPLog.INSTANCE.d(logTag , this.activeState + " -> " + nextState);
        this.activeState = nextState;
        this.activeState.actionOnEntry();
    }

    @Override
    public void shutDown(){
        mStateMachineExecutor.shutdown();
    }

    public boolean isInitialized(){
        return mStateMachineExecutor.isInitialized();
    }}
