/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;

public class LocalBroadcast {
    private static final String TAG = "LocalBroadcast";

    public static void sendBroadcast(String action) {
        Intent sendIntent = new Intent(action);
        try {
            LocalBroadcastManager.getInstance((Context)Infra.instance.getApplicationContext()).sendBroadcast(sendIntent);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000023, "Failed to send broadcast with action: " + action + ". And Reason is: ", e);
        }
    }

    public static void sendBroadcast(String action, Bundle bundle) {
        Intent sendIntent = new Intent(action);
        sendIntent.putExtras(bundle);
        try {
            LocalBroadcastManager.getInstance((Context)Infra.instance.getApplicationContext()).sendBroadcast(sendIntent);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000024, "Failed to send broadcast with action: " + action + " and bundle: " + LPLog.INSTANCE.mask(bundle.toString()) + ". And Reason is: ", e);
        }
    }
}

