package com.liveperson.infra.database;

import android.os.Handler;
import android.os.Looper;

import com.liveperson.infra.log.LPLog;

import static com.liveperson.infra.errors.ErrorCode.ERR_00000044;

/**
 * Created by Ilya Gazman on 9/7/2015.
 *
 * This class was copied from our previous SDK, it doesn't play any roll in this module
 * // TODO: 11/24/2015 do a proper commenting once this gets in to use
 */
public class DataBaseCommand<DATA> {

    private static final String TAG = "DataBaseCommand";

    private QueryCommand<DATA> mQueryCommand;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    protected QueryCallback<DATA> mPostQueryOnUI;
    protected Runnable mPreQueryOnBackground;
    protected QueryCallback<DATA> mPostQueryOnBackground;


    public DataBaseCommand(QueryCommand<DATA> queryCommand) {
        this.mQueryCommand = queryCommand;
    }

    public static <DATA> DataBaseCommand<DATA> create(DataBaseCommand.QueryCommand<DATA> queryCommand) {
        return new DataBaseCommand<>(queryCommand);
    }

    public DataBaseCommand<DATA> setPostQueryOnUI(QueryCallback<DATA> callback) {
        this.mPostQueryOnUI = callback;
        return this;
    }

    public DataBaseCommand<DATA> setPreQueryOnBackground(Runnable callback) {
        this.mPreQueryOnBackground = callback;
        return this;
    }

    public DataBaseCommand<DATA> setPostQueryOnBackground(QueryCallback<DATA> callback) {
        this.mPostQueryOnBackground = callback;
        return this;
    }


    public DATA executeSynchronously() {
        return mQueryCommand.query();
    }

    public void execute() {
        DataBaseExecutor.execute(() -> {
            try {
                if (mPreQueryOnBackground != null) {
                    mPreQueryOnBackground.run();
                }
                final DATA data = executeSynchronously();
                if (mPostQueryOnBackground != null) {
                    mPostQueryOnBackground.onResult(data);
                }
                if (mPostQueryOnUI != null) {
                    mUIHandler.post(() -> mPostQueryOnUI.onResult(data));
                }
            } catch (Exception e) {
	            LPLog.INSTANCE.e(TAG, ERR_00000044, "Error while running DataBaseCommand.", e);
            }
        });
    }

    public interface QueryCommand<T> {
        T query();
    }

    public interface QueryCallback<T> {
        void onResult(T data);
    }
}
