/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.TlsUtil;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.OkHttp3Downloader;
import com.squareup.picasso.Picasso;
import okhttp3.OkHttpClient;

public class PicassoUtils {
    private static final String TAG = "PicassoUtils";
    private static boolean initialized;

    public static Picasso get(@NonNull Context context) {
        if (Build.VERSION.SDK_INT == 19 && !initialized) {
            try {
                OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
                TlsUtil.enableTls12ForKitKat(clientBuilder);
                Picasso picasso = new Picasso.Builder(context).downloader((Downloader)new OkHttp3Downloader(clientBuilder.build())).build();
                initialized = true;
                Picasso.setSingletonInstance((Picasso)picasso);
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000011, "Fail to set picasso instance", e);
            }
        }
        return Picasso.get();
    }
}

